/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Paul Lehmann
 *   Co-authors:
 *      ...
 *
 *
 *
 */

#ifndef _NewScriptController_H__
#define _NewScriptController_H__

#include "scriptTasks/DebugTask.h"
#include "scriptTasks/stringOutTask.h"
#include "scriptTasks/MoveToTask.h"
#include "scriptTasks/Task.h"
#include "OrxonoxPrereqs.h"                 /* die ganzen tolua, kopiert aus Dock.h*/
#include "ArtificialController.h"
#include "core/EventIncludes.h"



namespace orxonox  // tolua_export
{  // tolua_export

    /**
    @brief

    A scriptController to carry out tasks on an entity.
    The tasks are provided as a lua script.
    The commands which are exported to lua have to create the specified task, initialze it and add it to the TaskList.

    Important add the export comment after functions that need to be accessed from the lua script.

    @todo

    take away the human controller and put it back into place when this controller is deleted.
    This is probably better done in the controller director class.

    remove the startTimes of the tasks so that the lua script is just carried out one task after the other.
    to avoid problems when to tasks are carried out simultainiously.

    also the velocity while the controller is taking control is kept and hinders the tasks.

    the moveToTask does not work right.
    */

    class _OrxonoxExport NewScriptController // tolua_export 
       : public ArtificialController, public Tickable
    {  // tolua_export
        public:
            NewScriptController(Context* context);
            virtual ~NewScriptController() { }

            void takeControl(int ctrlid);
            void setPlayer(PlayerInfo* player) { this->player_ = player; }
           
            virtual void tick(float dt) override;

            // LUA interface

            void debugOut(float startTime);// tolua_export

            void stringOut(float startTime, std::string output);// tolua_export

            void moveTo(float startTime, float x, float y, float z, float velocity);// tolua_export

            static NewScriptController* getNewScriptController();// tolua_export 

            int getID() { return ctrlid_; }// tolua_export 

            void printDebug() {orxout() << "fffff" << endl;} // tolua_export

        private:
            // Information about the player that this ScriptController will
            // control 
            // - Player pointer 
            PlayerInfo* player_;

            // - Entity pointer, this is for convenience and will be the same as 
            //   player_->getControllableEntity() 
            ControllableEntity* entity_;

            // Controller ID, defaults to 0 and is set using takeControl() 
            int ctrlid_;

            // List of events to walk through sorted by starting times
            std::list<Task*> taskList_;

            //List of Tasks currently active 
            std::vector<Task*> activeTasks_;

            // Time since the creation of this ScriptController object
            float scTime_;  


            // context of the Controller to create the tasks
            Context* context_;


    };// tolua_export
} // tolua_export

#endif /* _NewScriptController_H__ */