/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Paul Lehmann
 *   Co-authors:
 *      ...
 *
 */

 /*
  * Currently available lua commands:
  *
  * IMPORTANT: ALL COMMANDS DO REQUIRE 7 PARAMETERS TO BE PROVIDED. FILL UP WITH ZEROES IN UNIMPORTANT PLACES.
  *
  * Command             | Abbreviation | Parameter 1          | '' 2     | '' 3    | '' 4                 | '' 5     | '' 6     | '' 7
  *
  * "Move And Look"     | mal          | GoTo X Coordinate    |  '' Y ''  | '' Z '' | LookAt X Coordinate  |  '' Y '' |  '' Y '' | Duration
  * "Rotate And Look"   | ral          | GoTo X Coordinate    |  '' Y ''  | '' Z '' | Axis (1=x, 2=y, 3=z) |     -    |     -    | Duration
  * "Spiral"            | spi          | GoTo X Coordinate    |  '' Y ''  | '' Z '' |          -           |     -    |     -    | Duration
  * "Transition Look"   | chl          | From X Coordinate    |  '' Y ''  | '' Z '' | To X Coordinate      |  '' Y '' |  '' Y '' | Duration
  * "rotate round X crd"| rotX         | anchor coordinate    | angle(rad)|    -    |                      |          |          | Duration
  * "Idle (Do nothing)" | idle         | Duration
  */

#include "NewScriptController.h"

#include "scriptTasks/DebugTask.h"
#include "scriptTasks/stringOutTask.h"
#include "scriptTasks/MoveToTask.h"
#include "scriptTasks/Task.h"
#include "infos/PlayerInfo.h"
#include "core/CoreIncludes.h"
#include "worldentities/ControllableEntity.h"
#include "core/LuaState.h"
#include "util/Math.h"

namespace orxonox
{
    RegisterClass(NewScriptController);

    NewScriptController::NewScriptController(Context* context) : ArtificialController(context)
    {
        RegisterObject(NewScriptController);


        // Set default values for all variables 
        // - pointers to zero 
        this->player_ = nullptr;
        this->entity_ = nullptr;

        // - times
        this->scTime_ = 0.0f;

        this->context_ = context;

        
    }



    void NewScriptController::takeControl(int ctrlid)
    {
        // Output some debugging information 
        orxout(verbose) << "NewScriptController: Taking control" << endl;
        orxout(verbose) << "This-pointer: " << this << endl; 


        // Store the entity pointer in a private variable
        this->entity_ = this->player_->getControllableEntity();
        assert(this->entity_);

        this->ctrlid_ = ctrlid;
        if (this->ctrlid_ == 0)
        {
          this->ctrlid_ = 1;
        }
         
        // Add the controller here to this entity. Apparently this still leaves
        // any preexisting human controllers in place. 
         
        this->entity_->setDestroyWhenPlayerLeft(false);
        this->player_->stopTemporaryControl();
        this->entity_->setController(this);
        this->setControllableEntity(this->entity_);
        this->entity_->mouseLook();
        this->entity_->setVisible(true);
        
        // TODO take the human Controllers control  dont forget to give it back in the destructor
    }


    void NewScriptController::tick(float dt)
    {
        // Call the tick function of the classes we derive from 
        SUPER(NewScriptController, tick, dt);


        // If this controller has no entity entry, do nothing 
        if( !(this->entity_) ) return;

        if(!this->taskList_.empty())
        {
           orxout() << scTime_ << endl;

           orxout() << taskList_.size() << endl;


          if(this->taskList_.front()->getStartTime() < this->scTime_)
          {
              activeTasks_.push_back(this->taskList_.front());
              this->taskList_.pop_front();
          }
        }
        else
        {
          orxout() << "no tasks in taskList_" << endl;
        }

        std::vector<Task*>::iterator it = activeTasks_.begin();
        while (it != activeTasks_.end() )
        {
          if( !((*it)->update(dt)) )
          {
            (*(*it)).destroyLater();
            it = activeTasks_.erase(it);
          }
          else
          {
            it++;
          }

        }



        scTime_ += dt;
    }

    void NewScriptController::debugOut(float startTime)
    {

      DebugTask* task = new DebugTask(context_);

      task->initialize(startTime);

      bool inserted = false;

      if(taskList_.empty())
      {
        taskList_.push_front(task);
        inserted = true;
      }

      else
      {
        for (std::list<Task*>::iterator it = taskList_.begin(); it != taskList_.end(); it++) // insert sorted by starttime
        {
          orxout() << "debugOutTask" << endl;

          if(task->getStartTime() < (*it)->getStartTime() )
          {
            taskList_.insert(it, task);
            inserted = true;
            break;
          }
        }
      }

      if (!inserted)
      {
        taskList_.push_back(task);
      }
      
    }

    void NewScriptController::stringOut(float startTime, std::string output)
    {

      stringOutTask* task = new stringOutTask(context_);

      task->initialize(startTime, output);

      bool inserted = false;

      if(taskList_.empty())
      {
        taskList_.push_front(task);
        inserted = true;
      }

      else
      {
        for (std::list<Task*>::iterator it = taskList_.begin(); it != taskList_.end(); it++) // insert sorted by starttime
        {
          orxout() << "stringOutTask" << endl;

          if(task->getStartTime() < (*it)->getStartTime() )
          {
            taskList_.insert(it, task);
            inserted = true;
            break;
          }
        }
      }

      if (!inserted)
      {
        taskList_.push_back(task);
      }

    }

    void NewScriptController::moveTo(float startTime, float x, float y, float z, float velocity)
    {

      MoveToTask* task = new MoveToTask(context_);

      Vector3 destination = Vector3(x,y,z);

      task->initialize(startTime, player_, destination, velocity);

      bool inserted = false;

      if(taskList_.empty())
      {
        taskList_.push_front(task);
        inserted = true;
      }

      else
      {
        for (std::list<Task*>::iterator it = taskList_.begin(); it != taskList_.end(); it++) // insert sorted by starttime
        {
          orxout() << "stringOutTask" << endl;

          if(task->getStartTime() < (*it)->getStartTime() )
          {
            taskList_.insert(it, task);
            inserted = true;
            break;
          }
        }
      }

      if (!inserted)
      {
        taskList_.push_back(task);
      }

    }

    NewScriptController* NewScriptController::getNewScriptController() 
    {
      /* Output a message that confirms this function was called */
      orxout() << "Great success!" << std::endl;

      /* Debugging: print all the scriptcontroller object pointers */
      for(NewScriptController* controller : ObjectList<NewScriptController>())
      { orxout() << "Have object in list: " << controller << endl; }

      /* Find the first one with a nonzero ID */
      for(NewScriptController* controller : ObjectList<NewScriptController>())
      { 
        // TODO: do some selection here. Currently just returns the first one
        if( controller->getID() > 0 )
        { orxout() << "Controller to return: " << controller << endl;
          return controller;
        }
      
      }
      return nullptr;
    }

}
