/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Paul Lehmann
 *   Co-authors:
 *      ...
 *
 */

#ifndef _Task_H__
#define _Task_H__

#include "infos/PlayerInfo.h"
#include "tools/interfaces/Tickable.h"
//#include "core/class/OrxonoxClass.h"
#include "core/BaseObject.h"

namespace orxonox
{
    class _OrxonoxExport Task : public BaseObject {
   
        public:
            Task(Context* context);
            virtual ~Task(){}

            //this function needs to be called otherwise the task is never carried out
            void initialize(float startTime);

            //important return true while the task is running and false to stop it!!!
            virtual bool update(float dt) {return false;} 

            float getStartTime()
                {return startTime_;}

       //private:

        	float startTime_;

    };
}

#endif /* _Task_H__ */
