/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Matthias Binder
 *
 */


#ifndef _LevelStatus_H__
#define _LevelStatus_H__


#include "OrxonoxPrereqs.h"

#include <cassert>
#include <list>
#include <map>
#include <string>

#include "LevelInfo.h"

#include "util/Singleton.h"
#include "core/config/Configurable.h"


namespace orxonox
{

    /**
    @brief
        LevelStatus:
        In the LevelStatus class all necessary information of a mission in the campaign is saved.
        It is only used in the LevelManager to save the progress of the campaign. It is now possible to have a treelike campaign menu structure.
        
    */


    class _OrxonoxExport LevelStatus : public BaseObject
    {
    public:
        LevelStatus(Context* context);
        virtual ~LevelStatus();
        
        bool won;                           //if the Level is won or not
        std::vector<int> nextLevels;        //if this Level is won, the ith element of this vector shows, what to do with the other leves
        int activated;                      //0 not activated, 1 activated, 2 visible
    };
}

#endif /* _LevelStatus_H__ */
