/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#include "HUDChargeBar.h"

#include "util/Convert.h"
#include "core/CoreIncludes.h"
#include "worldentities/pawns/Pawn.h"
#include "overlays/OverlayGroup.h"


namespace orxonox
{
    RegisterClass(HUDChargeBar);

    HUDChargeBar::HUDChargeBar(Context* context) : HUDBar(context)
    {
        RegisterObject(HUDChargeBar);

        this->owner_ = nullptr;
        this->correspondingMode_ = nullptr;             // usually no chargeable weapon equipped
    }

    HUDChargeBar::~HUDChargeBar() { }

    void HUDChargeBar::tick(float dt)
    {
        SUPER(HUDChargeBar, tick, dt);

        if (this->owner_)
        {
            if(correspondingMode_ != nullptr)                                                                       // if there is a chargeable weapon equipped we want to show the charged amount with a HUDBar
            {
                this->setValue( correspondingMode_->getCharges() * 1.0f / correspondingMode_->getMaxCharges() );    // The Value of the HUDBar is the ratio of current Charges and the maximum Charges possible
                
                if(this->correspondingMode_->getCharges() > 0)                                                      // The HUDBar should only be visible when we are charging up
                {
                    this->setVisible(true);
                }
                else
                {
                    this->setVisible(false);
                }
            }
        }
        else
        {
            this->setValue(0);
        }

    }

    void HUDChargeBar::changedOwner()
    {
        SUPER(HUDChargeBar, changedOwner);

        this->setVisible(false);
        this->correspondingMode_ = nullptr;

        this->owner_ = orxonox_cast<Pawn*>(this->getOwner());
        if(this->owner_ == nullptr){
            return;
        }

        const WeaponSystem* weaponsystem = owner_->getWeaponSystem();
        if(weaponsystem == nullptr){
            return;
        }

        const std::vector<WeaponPack*> weaponpacklist = weaponsystem->getAllWeaponPacks();
        for(WeaponPack* weaponpack : weaponpacklist){
            const std::vector<Weapon*> weaponlist = weaponpack->getAllWeapons();
            for(Weapon* weapon : weaponlist){
                const std::multimap<unsigned int, WeaponMode*> weaponmodelist = weapon->getAllWeaponmodes();
                for(std::multimap<unsigned int, WeaponMode*>::const_iterator it = weaponmodelist.begin(); it != weaponmodelist.end(); ++it){
                    if(it->second->isChargeable()){
                        this->correspondingMode_ = it->second;
                        return;
                    }
                }
            }
        }
    }
}