/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      Tomer Gidron
 *
 */

#ifndef _HoverOrigin_H__
#define _HoverOrigin_H__

#include "HoverPrereqs.h"

#include "worldentities/StaticEntity.h"

namespace orxonox
{
    
    /**
    @brief
        The HoverOrigin implements the playing field @ref orxonox::Hover "Hover" takes place in and allows for many parameters of the minigame to be set.
        The playing field resides in the x,z-plane, with the x-axis being the horizontal axis and the z-axis being the vertical axis.
        For an example, have a look at the <code>Hover.oxw</code> level file.

    */
    class _HoverExport HoverOrigin : public StaticEntity
    {
        public:
            HoverOrigin(Context* context); //!< Constructor. Registers and initializes the object and checks whether the gametype is actually Hover.
            virtual ~HoverOrigin() = default;
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override; //!< Method to create a HoverOrigin through XML.
            
            inline void setNumCells(int numCells)
                { this->numCells_ = numCells; }
            inline int getNumCells() const
                { return this->numCells_; }

            inline void setCellSize(int cellSize)
                { this->cellSize_ = cellSize; }
            inline int getCellSize() const
                { return this->cellSize_; }

            inline void setCellHeight(int cellHeight)
                { this->cellHeight_ = cellHeight; }
            inline int getCellHeight() const
                { return this->cellHeight_; }

            inline void setWallThickness(int wallThickness)
                { this->wallThickness_ = wallThickness; }
            inline int getWallThickness() const
                { return this->wallThickness_; }

            //pickup template set and get for destroy hover pickup

            inline void setPickupTemplate(std::string pickupTemplate)
                { this->pickupTemplate_ = pickupTemplate; }
            inline std::string getPickupTemplate() const
                { return this->pickupTemplate_; }

            inline void setPickupRepresentationTemplate(std::string pickupRepresenationaTemplate)
                { this->pickupRepresentationTemplate_ = pickupRepresenationaTemplate; }
            inline std::string getPickupRepresentationTemplate() const
                { return this->pickupRepresentationTemplate_; }

            //pickup template get and set for damage hover pickup

            inline void setPickupTemplateSpeed(std::string pickupTemplateSpeed)
                { this->pickupTemplateSpeed_ = pickupTemplateSpeed; }
            inline std::string getPickupTemplateSpeed() const
                { return this->pickupTemplateSpeed_; }

            inline void setPickupRepresentationTemplateSpeed(std::string pickupRepresenationaTemplateSpeed)
                { this->pickupRepresentationTemplateSpeed_ = pickupRepresenationaTemplateSpeed; }
            inline std::string getPickupRepresentationTemplateSpeed() const
                { return this->pickupRepresentationTemplateSpeed_; }


            //pickup template get and set for shrink hover pickup

            inline void setPickupTemplateShrink(std::string pickupTemplateShrink)
                { this->pickupTemplateShrink_ = pickupTemplateShrink; }
            inline std::string getPickupTemplateShrink() const
                { return this->pickupTemplateShrink_; }

            inline void setPickupRepresentationTemplateShrink(std::string pickupRepresenationaTemplateShrink)
                { this->pickupRepresentationTemplateShrink_ = pickupRepresenationaTemplateShrink; }
            inline std::string getPickupRepresentationTemplateShrink() const
                { return this->pickupRepresentationTemplateShrink_; }

            //get and set for obstacle template

            inline void setObstacleTemplate(std::string obstacleTemplate)
                { this->obstacleTemplate_ = obstacleTemplate; }
            inline std::string getObstacleTemplate() const
                { return this->obstacleTemplate_; }        

            //get and set for ground template

            inline void setGroundTemplate(std::string groundTemplate)
                { this->groundTemplate_ = groundTemplate; }
            inline std::string getGroundTemplate() const
                { return this->groundTemplate_; }  

        private:
            void checkGametype();

       
            int numCells_;
            int cellSize_;
            int cellHeight_;
            int wallThickness_;

            // Tempaltes for the destroy hover pickup
            std::string pickupTemplate_;
            std::string pickupRepresentationTemplate_;

            // Tempaltes for the damage hover pickup
            std::string pickupTemplateSpeed_;
            std::string pickupRepresentationTemplateSpeed_;

            // Tempaltes for the shrink hover pickup
            std::string pickupTemplateShrink_;
            std::string pickupRepresentationTemplateShrink_;

            //Template for crate obstacle
            std::string obstacleTemplate_;

            //Template for ground cell
            std::string groundTemplate_;
    };
}

#endif /* _HoverOrigin_H__ */
