/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Tomer Gidron
 *
 */

 /**
    @file TFlagsLivesLevelHUD.h
    @brief Declaration of the TFlagsLivesLevelHUD class.
*/

#ifndef _TFlagsLivesLevelHUD_H__
#define _TFlagsLivesLevelHUD_H__


#include "HoverPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "overlays/OverlayText.h"

namespace orxonox
{
    class _HoverExport TFlagsLivesLevelHUD : public OverlayText, public Tickable
    {
        public:
            TFlagsLivesLevelHUD(Context* context);

            virtual void tick(float dt) override;
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void changedOwner() override;

            /// sets TOTAL flags taken
            inline void setShowTot(int totFlags)
                { this->totFlags_ = totFlags; }
            /// returns TOTAL flags >=0
            inline int getShowTot() const
                { return this->totFlags_; }

            /// sets show tot lives
            void setShowLives(const bool showLives)
                { showLives_ = showLives; }
            /// gets show tot lives
            const bool getShowLives() const
                { return showLives_; }

            /// sets show level
            void setShowLevel(const bool showLevel)
                { showLevel_ = showLevel; }
            /// gets show level
            const bool getShowLevel() const
                { return showLevel_; }

            /// sets show tot flags
            void setShowTotFlags(const bool showTotFlags)
                { showTotFlags_ = showTotFlags; }
            /// gets show tot flags
            const bool getShowTotFlags() const
                { return showTotFlags_; }

            /// sets Game Level
            inline void setTotLevel(int totLevel)
                { this->totLevel_ = totLevel; }
            /// returns level >=0
            inline int getTotLevel() const
                { return this->totLevel_; }

            /// sets level Upgrade
            void setLevelUpgrade(const bool levelUpgrade)
                { levelUpgrade_ = levelUpgrade; }
            /// gets level Upgrade
            const bool getLevelUpgrade() const
                { return levelUpgrade_; }


        private:
            Hover* hoverGame_;
            int totFlags_;
            int totLevel_;
            bool showLives_;
            bool showLevel_;
            bool showTotFlags_;
            bool levelUpgrade_;
    };
}
#endif /* _TFlagsLivesLevelHUD_H__ */