/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Tomer Gidron
 *
 */

#include "TFlagsLivesLevelHUD.h"
#include "HoverFlag.h"
#include "Hover.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"

namespace orxonox
{
    RegisterClass(TFlagsLivesLevelHUD);

    TFlagsLivesLevelHUD::TFlagsLivesLevelHUD(Context* context) : OverlayText(context)
    {
        RegisterObject(TFlagsLivesLevelHUD);

        this->hoverGame_ = nullptr;
        this->totFlags_ = 0;
        showLives_ = true;
        showLevel_ = true;
        showTotFlags_= true;
        levelUpgrade_ = true;
    }

    void TFlagsLivesLevelHUD::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(TFlagsLivesLevelHUD, XMLPort, xmlelement, mode);

        XMLPortParam(TFlagsLivesLevelHUD,"showPoints", setShowTot, getShowTot, xmlelement, mode);
        XMLPortParam(TFlagsLivesLevelHUD, "showLives", setShowLives, getShowLives, xmlelement, mode);
        XMLPortParam(TFlagsLivesLevelHUD, "showLevel", setShowLevel, getShowLevel, xmlelement, mode);
        XMLPortParam(TFlagsLivesLevelHUD, "levelUpgrade", setLevelUpgrade, getLevelUpgrade, xmlelement, mode);
    }

    void TFlagsLivesLevelHUD::tick(float dt)
    {
        SUPER(TFlagsLivesLevelHUD, tick, dt);

            const std::string& flags = multi_cast<std::string>(this->hoverGame_->getTotFlags());
            const std::string& lives = multi_cast<std::string>(this->hoverGame_->getLives());
            const std::string& level = multi_cast<std::string>(this->hoverGame_->getLevel());

            //Display total Flags taken
            if(showTotFlags_ == true){
                setTextSize(0.04);
                setPosition(Vector2(0.18, 0.08));
                this->setColour(ColourValue(1, 1, 1, 1));
                this->setCaption(flags);
            }

            //Display remaining lives
            if(showLives_ == true){
                setTextSize(0.04);
                setPosition(Vector2(0.18, 0.12));
                this->setColour(ColourValue(1, 1, 1, 1));
                this->setCaption(lives);
            }

            //Display current level
            if(showLevel_ == true){
                setTextSize(0.04);
                setPosition(Vector2(0.18, 0.16));
                this->setColour(ColourValue(1, 1, 1, 1));
                this->setCaption(level);
                
            }
            
            //New Level pop up
            if(this->hoverGame_->bLevelUpgradeHUD  && levelUpgrade_)
                {
                setTextSize(0.2);
                setPosition(Vector2(0.3, 0.45));
                std::stringstream sstm;
                sstm << "Level " << level;
                this->setCaption(sstm.str());

                //TODO
                //make others stop blinking when new level pop-up is activated
                }

    }

    void TFlagsLivesLevelHUD::changedOwner()
    {
        SUPER(TFlagsLivesLevelHUD, changedOwner);

        if (this->getOwner() && this->getOwner()->getGametype())
        {
            this->hoverGame_ = orxonox_cast<Hover*>(this->getOwner()->getGametype());
        }
        else
        {
            this->hoverGame_ = nullptr;
        }
    }
}
