/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      Tomer Gidron
 *
 */

/**
    @file HoverOrigin.cc
    @brief The HoverOrigin is a StaticEntity which represents the level of the minigame. All platforms, enemies and items are attached to the HoverOrigin.
*/

#include "HoverOrigin.h"
#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "Hover.h"

namespace orxonox
{
    RegisterClass(HoverOrigin);

    HoverOrigin::HoverOrigin(Context* context) : StaticEntity(context)
    {
        RegisterObject(HoverOrigin);
        checkGametype();

        //Initialization of variables (not really needed)

        pickupTemplate_ = "";
        pickupRepresentationTemplate_ = "";

        pickupTemplateSpeed_ = "";
        pickupRepresentationTemplateSpeed_ = "";


        pickupTemplateShrink_ = "";
        pickupRepresentationTemplateShrink_ = "";
    }

    void HoverOrigin::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HoverOrigin, XMLPort, xmlelement, mode);

        XMLPortParam(HoverOrigin, "numCells", setNumCells, getNumCells, xmlelement, mode);
        XMLPortParam(HoverOrigin, "cellSize", setCellSize, getCellSize, xmlelement, mode);
        XMLPortParam(HoverOrigin, "cellHeight", setCellHeight, getCellHeight, xmlelement, mode);
        XMLPortParam(HoverOrigin, "wallThickness", setWallThickness, getWallThickness, xmlelement, mode);
        XMLPortParam(HoverOrigin, "pickuptemplate", setPickupTemplate, getPickupTemplate, xmlelement, mode);
        XMLPortParam(HoverOrigin, "pickuprepresentationtemplate", setPickupRepresentationTemplate, getPickupRepresentationTemplate, xmlelement, mode);
        XMLPortParam(HoverOrigin, "pickuptemplatespeed", setPickupTemplateSpeed, getPickupTemplateSpeed, xmlelement, mode);
        XMLPortParam(HoverOrigin, "pickuprepresentationtemplatespeed", setPickupRepresentationTemplateSpeed, getPickupRepresentationTemplateSpeed, xmlelement, mode);
        XMLPortParam(HoverOrigin, "obstacletemplate", setObstacleTemplate, getObstacleTemplate, xmlelement, mode);
        XMLPortParam(HoverOrigin, "pickuptemplateshrink", setPickupTemplateShrink, getPickupTemplateShrink, xmlelement, mode);
        XMLPortParam(HoverOrigin, "pickuprepresentationtemplateshrink", setPickupRepresentationTemplateShrink, getPickupRepresentationTemplateShrink, xmlelement, mode);
        XMLPortParam(HoverOrigin, "groundtemplate", setGroundTemplate, getGroundTemplate, xmlelement, mode);
    }


    void HoverOrigin::checkGametype()
    {
        if (getGametype() != nullptr && this->getGametype()->isA(Class(Hover)))
        {
            Hover* hoverGametype = orxonox_cast<Hover*>(this->getGametype());
            hoverGametype->setOrigin(this);
        }
    }
}
