/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Matthias Binder
 *
 */




#include "LevelStatus.h"

#include <map>

#include "core/singleton/ScopedSingletonIncludes.h"
#include "core/commandline/CommandLineIncludes.h"
#include "core/config/ConfigValueIncludes.h"
#include "core/CoreIncludes.h"
#include "core/ClassTreeMask.h"
#include "core/Loader.h"
#include "core/Resource.h"
#include "core/XMLFile.h"
#include "Level.h"
#include "PlayerManager.h"

namespace orxonox
{
    RegisterClass(LevelStatus);


    /**
    @brief
        Constructor. sets config values and initializes variables.
    */
    LevelStatus::LevelStatus(Context* context) : BaseObject(context)
    {
        RegisterObject(LevelStatus);
        this->won = false;
        this->nextLevels.insert(this->nextLevels.begin(),1);
        this->activated=0;
    }

    LevelStatus::~LevelStatus()
    {}
}
