#include <gtest/gtest.h>
#include "core/CoreIncludes.h"
#include "core/class/Identifiable.h"
#include "core/module/ModuleInstance.h"

namespace orxonox
{
    namespace
    {
        class IdentifiableClass : public Identifiable
        {
            public:
                IdentifiableClass() { RegisterObject(IdentifiableClass); }
        };

        RegisterClassNoArgs(IdentifiableClass);

        // Fixture
        class IdentifiableTest : public ::testing::Test
        {
            public:
                virtual void SetUp() override
                {
                    new IdentifierManager();
                    ModuleInstance::getCurrentModuleInstance()->loadAllStaticallyInitializedInstances(StaticInitialization::IDENTIFIER);
                }

                virtual void TearDown() override
                {
                    ModuleInstance::getCurrentModuleInstance()->unloadAllStaticallyInitializedInstances(StaticInitialization::IDENTIFIER);
                    delete &IdentifierManager::getInstance();
                }
        };
    }

    TEST_F(IdentifiableTest, CanCreate)
    {
        IdentifiableClass* test = new IdentifiableClass();
        ASSERT_TRUE(test != nullptr);
        delete test;
    }

    TEST_F(IdentifiableTest, HasIdentifierAssigned)
    {
        IdentifiableClass test;
        EXPECT_TRUE(test.getIdentifier());
    }

    TEST_F(IdentifiableTest, CanBeIdentified)
    {
        IdentifiableClass test;
        EXPECT_TRUE(test.isA(Class(IdentifiableClass)));
    }
}
