/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Vedat Aydin
 *   Co-authors:
 *      ...
 *
 */

#ifndef _ExplosionPart_H__
#define _ExplosionPart_H__

#include "OrxonoxPrereqs.h"

#include "graphics/Model.h"
#include "tools/ParticleInterface.h"
#include "MovableEntity.h"
#include "graphics/ParticleSpawner.h"
#include "core/CoreIncludes.h"
#include "core/GameMode.h"
#include "util/Exception.h"
#include "core/command/Executor.h"
#include "Scene.h"
#include "tools/Timer.h"


 namespace orxonox
{
    class _OrxonoxExport ExplosionPart : public MovableEntity
    {
        public:
            ExplosionPart(Context* context);
            ~ExplosionPart();
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;

            void Explode();
            void stop();
            void ActuallyExplode();

            void setMesh(const std::string& newString);
            std::string& getMesh();
            void setEffect1(const std::string& newString);
            std::string& getEffect1();
            void setEffect2(const std::string& newString);
            std::string& getEffect2();
            void setMinSpeed(float speed);
            float getMinSpeed();
            void setMaxSpeed(float speed);
            float getMaxSpeed();
            void setOffset(Vector3 newVector);
            Vector3 getOffset();
            void setDirection(Vector3 newDirection);
            Vector3 getDirection();
            void setAngle(float newAgnle);
            float getAngle();
            void setDelay(float newDelay);
            float getDelay();
         

        private:

            bool bStop_;
            LODParticle::Value LOD_;


            Model* model_;
            ParticleInterface* effect1Particle_;
            ParticleInterface* effect2Particle_;


            float minSpeed_;
            float maxSpeed_;
            std::string mesh_;
            std::string effect1_;
            std::string effect2_;
            Vector3 posOffset_;
            Vector3 direction_;
            float angle_;
            float delay_;

            MovableEntity* explosionEntity_;

            Timer destroyTimer_;



    };
}

#endif /* _ExplosionPart_H__ */
