/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#ifndef _CommonController_H__
#define _CommonController_H__


#include "controllers/Controller.h"                 //that's what I inherit from

#include <limits>                                   //I use limits pretty much in every class, so might as well include it in the parent class

#include "worldentities/ControllableEntity.h"       //same for ControllableEntity
#include "worldentities/pawns/Pawn.h"               //and Pawn


namespace orxonox
{
    class _OrxonoxExport CommonController : public Controller
    {

        public:
            static const float HARDCODED_PROJECTILE_SPEED; //<! FightingController uses it to predict enemy position

            CommonController(Context* context);
            virtual ~CommonController();
            static float randomInRange(float a, float b);   //<! returns random number from a to b
            static float distance(const ControllableEntity* entity1, const ControllableEntity* entity2);    //<! returns distance between arguments
            static bool sameTeam (ControllableEntity* entity1, ControllableEntity* entity2, Gametype* gt);
            static bool isLooking(const ControllableEntity* entityThatLooks, const ControllableEntity* entityBeingLookedAt, float angle) ;
            static std::string getName(const Pawn* entity) ;           
    };
}

#endif /* _CommonController_H__ */
