/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file SplitGun.h
    @brief Definition of the SplitGun class.
*/

#ifndef _SplitGun_H__
#define _SplitGun_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        A WeaponMode that fires projectiles that may split up into many other projectiles, that may again split up ...
    @author
        Fabien Vultier
    @ingroup WeaponsWeaponModes
    */
    class _WeaponsExport SplitGun : public WeaponMode
    {
        public:
            SplitGun(Context* context);
            virtual ~SplitGun();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void fire() override;

            inline void setNumberOfSplits(int numberOfSplits)
                { this->numberOfSplits_ = numberOfSplits; }
            inline int getNumberOfSplits() const
                { return this->numberOfSplits_; }
            inline void setNumberOfChilds(int numberOfChilds)
                { this->numberOfChilds_ = numberOfChilds; }
            inline int getNumberOfChilds() const
                { return this->numberOfChilds_; }
            inline void setSplitTime(float splitTime)
                { this->splitTime_ = splitTime; }
            inline float getSplitTime() const
                { return this->splitTime_; }
            inline void setSpread(float spread)
                { this->spread_ = spread; }
            inline float getSpread() const
                { return this->spread_; }
            inline void setDamageReduction(float damageReduction)
                { this->damageReduction_ = (damageReduction >= 0.0f ? damageReduction : 1.0f); }
            inline float getDamageReduction() const
                { return this->damageReduction_; }

       private:
            float speed_; //The speed of the fired projectile.
            int numberOfSplits_; //The number of times the projectile will split into child projectiles
            int numberOfChilds_; //The number of child projectiles that are created if the projectile splits
            float splitTime_; //The time between creation of the projectile and the split of the projectile
            float spread_; //Low spread means that the child projectiles are concentrated in a small area
            float damageReduction_; //The damage of a child projectile is reduced by this factor
    };
}

#endif /* _SplitGun_H__ */
