/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */


#ifndef _TowerDefenseCenterpoint_H__
#define _TowerDefenseCenterpoint_H__

#include "towerdefense/TowerDefensePrereqs.h"

#include <string>
#include <util/Math.h>
#include "TowerDefenseTower.h"
#include "worldentities/MobileEntity.h"

namespace orxonox
{
    /**
    @brief
    See TowerDefenseReadme.txt for Information.
    @ingroup TowerDefense
    */
    class _TowerDefenseExport TowerDefenseCenterpoint : public MobileEntity
    {
        public:
            TowerDefenseCenterpoint(Context* context);
            virtual ~TowerDefenseCenterpoint() {}

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;

            /**
            @brief The width and hight in number of tiles. Default is 15 for both.
            */
            void setWidth(unsigned int width)
                { this->width_ = width; }
            unsigned int getWidth(void) const
                { return this->width_; }
            void setHeight(unsigned int height)
                { this->height_ = height; }
            unsigned int getHeight(void) const
                { return this->height_; }
            void setFields(const std::string& newFields)
                { this->fields_ = newFields; trimString(&fields_); }
            const std::string& getFields() const
                { return this->fields_; }                    
            void setSelecterTemplate(const std::string& newTemplate)
                { this->selecterTemplate_ = newTemplate; }
            const std::string& getSelecterTemplate() const
                { return this->selecterTemplate_; }   

            void setTower1Template(const std::string& newTemplate)
                { this->towerTemplates_[0] = newTemplate;}
            const std::string& getTower1Template() const
                { return this->towerTemplates_[0]; }  
            void setTower2Template(const std::string& newTemplate)
                { this->towerTemplates_[1] = newTemplate; }
            const std::string& getTower2Template() const
                { return this->towerTemplates_[1]; }
            void setTower3Template(const std::string& newTemplate)
                { this->towerTemplates_[2] = newTemplate; }
            const std::string& getTower3Template() const
                { return this->towerTemplates_[2]; } 
            void setTower4Template(const std::string& newTemplate)
                { this->towerTemplates_[3] = newTemplate; }
            const std::string& getTower4Template() const
                { return this->towerTemplates_[3]; }
            void setTower5Template(const std::string& newTemplate)
                { this->towerTemplates_[4] = newTemplate; }
            const std::string& getTower5Template() const
                { return this->towerTemplates_[4]; }  

            void setTower1Cost(const int& newCost)
                { this->towerCosts_[0] = newCost;}
            const int& getTower1Cost() const
                { return this->towerCosts_[0]; }  
            void setTower2Cost(const int& newCost)
                { this->towerCosts_[1] = newCost; }
            const int& getTower2Cost() const
                { return this->towerCosts_[1]; }
            void setTower3Cost(const int& newCost)
                { this->towerCosts_[2] = newCost; }
            const int& getTower3Cost() const
                { return this->towerCosts_[2]; } 
            void setTower4Cost(const int& newCost)
                { this->towerCosts_[3] = newCost; }
            const int& getTower4Cost() const
                { return this->towerCosts_[3]; }
            void setTower5Cost(const int& newCost)
                { this->towerCosts_[4] = newCost; }
            const int& getTower5Cost() const
                { return this->towerCosts_[4]; }

            const int getTowerCost(int upgrade) const;
                                            

            /**
                @brief How to convert to world coordinates, e.g. that 0,15 is not at -8,-8 but at -80,-80 (if scale would be 10)
            */
            void setTileScale(unsigned int tileScale)
                { this->tileScale_ = tileScale; }

            unsigned int getTileScale(void) const
                { return this->tileScale_; }

        private:
            void checkGametype();
            void trimString(std::string*);
            std::string selecterTemplate_;
            std::string towerTemplates_[5];
            int towerCosts_[5];
            std::string fields_;
            unsigned int width_;
            unsigned int height_;
            unsigned int tileScale_;
    };
}

#endif /* _TowerDefenseCenterpoint_H__ */
