 #
 #             ORXONOX - the hottest 3D action shooter ever to exist
 #                             > www.orxonox.net <
 #
 #        This program is free software; you can redistribute it and/or
 #         modify it under the terms of the GNU General Public License
 #        as published by the Free Software Foundation; either version 2
 #            of the License, or (at your option) any later version.
 #
 #       This program is distributed in the hope that it will be useful,
 #        but WITHOUT ANY WARRANTY; without even the implied warranty of
 #        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #                 GNU General Public License for more details.
 #
 #   You should have received a copy of the GNU General Public License along
 #      with this program; if not, write to the Free Software Foundation,
 #     Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 #
 #
 #  Author:
 #    Adrian Friedli
 #  Description:
 #    Sets the correct find script paths on the ETH Tardis workstations.
 #    Also sets the TARDIS variable.
 #

IF(LINUX AND EXISTS /etc/hostname)
  FILE(STRINGS /etc/hostname HOSTNAME LIMIT_COUNT 1)
  IF(${HOSTNAME} MATCHES "^tardis-[a-z][0-9][0-9]$")
    SET (TARDIS ON)
  ENDIF()
ENDIF()

IF(TARDIS)
  MESSAGE(STATUS "Running on D-ITET isg.ee Tardis Computer. Using customized paths.")

  SET(DO_NOT_UNLOAD_PLUGINS ON)

#  SET(CMAKE_C_COMPILER "gcc-4.1.1")
#  SET(CMAKE_CXX_COMPILER "g++-4.1.1")

#  LIST(APPEND CMAKE_INCLUDE_PATH "/usr/pack/cegui-0.6.2-sd")
#  LIST(APPEND CMAKE_LIBRARY_PATH "/usr/pack/cegui-0.6.2-sd/amd64-debian-linux5.0")
#  LIST(APPEND CMAKE_INCLUDE_PATH "/usr/pack/ogre-1.6.1-sd")
#  LIST(APPEND CMAKE_LIBRARY_PATH "/usr/pack/ogre-1.6.1-sd/amd64-debian-linux5.0")

  #Solution to the problem that on the new tardis machines, we needed to run Orxonox with the command
  # bash && LD_LIBRARY_PATH=/usr/pack/libcg-1.5-sd/amd64-debian-linux3.1/lib/ ./run
  link_directories(/usr/pack/libcg-1.5-sd/amd64-debian-linux3.1/lib/)
  #SET(ENV{CEGUIDIR}    "/usr/pack/cegui-0.6.2-sd;/usr/pack/cegui-0.6.2-sd/i686-debian-linux5.0")
  #SET(ENV{ENETDIR}     "/usr/pack/enet-1.2-sd;/usr/pack/enet-1.2-sd/i686-debian-linux4.0")
  #SET(ENV{ALUTDIR}     "/usr/pack/openal-0.0.8-cl;/usr/pack/openal-0.0.8-cl/i686-debian-linux3.1")
  #SET(ENV{OGGDIR}      "/usr/pack/oggvorbis-1.0-ds;/usr/pack/oggvorbis-1.0-ds/i686-debian-linux3.0")
  #SET(ENV{VORBISDIR}   "/usr/pack/oggvorbis-1.0-ds;/usr/pack/oggvorbis-1.0-ds/i686-debian-linux3.0")
  #SET(ENV{LUA5.1_DIR}  "/usr/pack/lua-5.1.4-sd;/usr/pack/lua-5.1.4-sd/i686-debian-linux4.0")
  #SET(ENV{OGRE_HOME}   "/usr/pack/ogre-1.4.9-sd;/usr/pack/ogre-1.4.9-sd/i686-debian-linux4.0")
  #SET(ENV{OPENALDIR}   "/usr/pack/openal-0.0.8-cl;/usr/pack/openal-0.0.8-cl/i686-debian-linux3.1")
  #SET(TCL_INCLUDE_PATH "/usr/pack/tcltk-8.4.9.linux-mo/include")

  # New paths for the new tardis system. The ogre includes need to be at ../dependencies.
  SET(OGRE_INCLUDE_DIR "${CMAKE_CURRENT_SOURCE_DIR}/../dependencies/ogre_src_v1-8-0/OgreMain/include/")
  SET(OGRE_LIBRARY_OPTIMIZED "/usr/lib/x86_64-linux-gnu/libOgreMain.so.1.8.0")
  SET(OGRE_PLUGIN_Plugin_ParticleFX_OPTIMIZED "/usr/lib/x86_64-linux-gnu/OGRE-1.8.0/Plugin_ParticleFX.so")
  SET(OGRE_PLUGIN_RenderSystem_GL_OPTIMIZED "/usr/lib/x86_64-linux-gnu/OGRE-1.8.0/RenderSystem_GL.so")


  # Sandro fix: add flag that re-enables boost threads. This makes the combination
  #             of GCC version > 4.7 and older libboost work. See 
  # http://stackoverflow.com/questions/5389853/doesnt-compile-if-included-boost-thread-in-linux-ubuntu10-10
  #             for more information.
  ADD_COMPILER_FLAGS("-D_GLIBCXX__PTHREADS=1" CXX CACHE)
ENDIF(TARDIS)
