 #
 #             ORXONOX - the hottest 3D action shooter ever to exist
 #                             > www.orxonox.net <
 #
 #        This program is free software; you can redistribute it and/or
 #         modify it under the terms of the GNU General Public License
 #        as published by the Free Software Foundation; either version 2
 #            of the License, or (at your option) any later version.
 #
 #       This program is distributed in the hope that it will be useful,
 #        but WITHOUT ANY WARRANTY; without even the implied warranty of
 #        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #                 GNU General Public License for more details.
 #
 #   You should have received a copy of the GNU General Public License along
 #      with this program; if not, write to the Free Software Foundation,
 #     Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 #
 #
 #  Author:
 #    Martin Mueller
 #  Description:
 #    Sets the right compiler and linker flags for Clang.
 #

INCLUDE(FlagUtilities)

# Shortcut for CMAKE_CXX_COMPILER_ID MATCHES Clang
SET(CMAKE_COMPILER_IS_CLANG TRUE)

# Generate compilation database for clang tooling
SET(CMAKE_EXPORT_COMPILE_COMMANDS TRUE)

SET(PCH_COMPILER_SUPPORT TRUE)
SET(HAVE_COUNTER_MACRO TRUE)

# Also include environment flags. Could cause conflicts though
SET_COMPILER_FLAGS("$ENV{CXXFLAGS}" CXX CACHE)
SET_COMPILER_FLAGS("$ENV{CFLAGS}"   C   CACHE)

# These flags get added to the flags above
SET_COMPILER_FLAGS("    -g -D_DEBUG" Debug          CACHE)
SET_COMPILER_FLAGS("       -DNDEBUG" ReleaseAll     CACHE)
ADD_COMPILER_FLAGS("-O2 -g"          RelForDevs     CACHE)
ADD_COMPILER_FLAGS("-O3 -g"          RelWithDebInfo CACHE)
ADD_COMPILER_FLAGS("-O3"             Release        CACHE)
ADD_COMPILER_FLAGS("-Os"             MinSizeRel     CACHE)

# Introducing c++11
ADD_COMPILER_FLAGS("-std=c++11" CXX CACHE)

# Never omit frame pointers that could interfere with proper stack traces
ADD_COMPILER_FLAGS("-fno-omit-frame-pointer" CACHE)

# Enable non standard floating point optimisations
ADD_COMPILER_FLAGS("-ffast-math" CACHE)

ADD_COMPILER_FLAGS("-DORXONOX_GCC_VISIBILITY -fvisibility=default -fvisibility-inlines-hidden" CACHE)

# We have some unconformant code, disable an optimisation feature
ADD_COMPILER_FLAGS("-fno-strict-aliasing" CACHE)

# Don't display hundreds of annoying deprecated messages
ADD_COMPILER_FLAGS("-Wno-deprecated" CXX CACHE)

# Clang doesn't like some narrowing bullet does
ADD_COMPILER_FLAGS("-Wno-c++11-narrowing" CXX CACHE)

# Always show why a precompiled header file could not be used
ADD_COMPILER_FLAGS("-Winvalid-pch" CXX CACHE)

# Increase warning level if requested
IF(EXTRA_COMPILER_WARNINGS)
  ADD_COMPILER_FLAGS("-Wall -Wextra -Wno-unused-parameter" CACHE)
ELSE()
  REMOVE_COMPILER_FLAGS("-Wextra -Wno-unused-parameter" CACHE)
  ADD_COMPILER_FLAGS("-Wall" CACHE)
ENDIF()

# Linker flags
IF(LINUX)
  # Don't allow undefined symbols in a shared library
  SET_LINKER_FLAGS("-Wl,--no-undefined" CACHE)
ENDIF()
