/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Paul Lehmann
 *   Co-authors:
 *      ...
 *
 */

#ifndef _MoveToTask_H__
#define _MoveToTask_H__

#include "infos/PlayerInfo.h"
#include "controllers/ArtificialController.h"
#include "tools/interfaces/Tickable.h"
#include "Task.h"

namespace orxonox
{
    class _OrxonoxExport MoveToTask : public Task
    {
        public:
            MoveToTask(Context* context);
            virtual ~MoveToTask(){}

            void initialize(float startTime, PlayerInfo* player, vector3 destination);

            virtual bool update(float dt) override;

        private:

            std::string output_;

            // Information about the player that this ScriptController will
            // control 
            // - Player pointer 
            PlayerInfo* player_;

            // - Entity pointer, this is for convenience and will be the same as 
            //   player_->getControllableEntity() 
            ControllableEntity* entity_;

            vector3 destination_;

            float velocity_;

    };
}

#endif /* _MoveToTask_H__ */