/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Paul Lehmann
 *   Co-authors:
 *      ...
 *
 */


#include "MoveToTask.h"

#include "infos/PlayerInfo.h"
#include "controllers/ArtificialController.h"

namespace orxonox
{
   
    RegisterClass(MoveToTask);

    MoveToTask::MoveToTask(Context* context): Task(context)
    {
        RegisterObject(MoveToTask);
    }

    void MoveToTask::initialize(float startTime, PlayerInfo* player, Vector3 destination, float velocity)
    {
        this->starTime_ = startTime;
        this->player_ = player;
        this->entity_ = this->player_->getControllableEntity();
        this->destination_ = destination;
        this->velocity_ = velocity;
        this->entity->setVelocity( Vector3(0,0,0) )
    }

    bool MoveToTask::update(float dt)
    {

        float dl = this->velocity_ * dt;

        
        /* Set the position to the correct place in the trajectory */
        this->entity_->setPosition( (1-dl)*startpos + dl * this->currentEvent.v1);

        /* Look at the specified position */
        this->entity_->lookAt(this->currentEvent.v2);

    }

}