//
//  TowerDefenseEnemy.cc
//  Orxonox
//
//  Created by Jonas Erb on 22.10.14.

/**
@brief
See TowerDefenseReadme.txt for Information.

@ingroup TowerDefense
*/
#include "TowerDefenseEnemy.h"
#include "core/CoreIncludes.h"
//#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(TowerDefenseEnemy);

    /**
    @brief
        Constructor. Registers and initializes the object.
    */
    TowerDefenseEnemy::TowerDefenseEnemy(Context* context) : SpaceShip(context)
    {
        RegisterObject(TowerDefenseEnemy);

        this->setCollisionType(WorldEntity::CollisionType::Dynamic);
        //needed to keep track of the PlayerStats coded in TowerDefense.h
        this->td = orxonox_cast<TowerDefense*>(this->getGametype());
        once_ = false;
    }

    TowerDefenseEnemy::~TowerDefenseEnemy()
    {

    }

    WeakPtr<TowerDefense> TowerDefenseEnemy::getGame()
    {
        if (game == nullptr)
        {
            for (TowerDefense* towerDefense : ObjectList<TowerDefense>())
                game = towerDefense;
        }
        return game;
    }

    void TowerDefenseEnemy::damage(float damage, float healthdamage, float shielddamage, Pawn* originator, const btCollisionShape* cs)
    {
        Pawn::damage(damage, healthdamage, shielddamage, originator);
        
        if (getGame() && once_ == false && getHealth() <= 0)
        {
            getGame()->addCredit(1);
            once_ = true;
        }
    }
}
