/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MunitionContainer.h
    @brief Declaration of the MunitionContainer class.
    @ingroup PickupItems
*/

#ifndef _MunitionContainer_H__
#define _MunitionContainer_H__

#include "pickup/PickupPrereqs.h"

#include <string>

#include "pickup/Pickup.h"
#include "core/class/SubclassIdentifier.h"
#include "weaponsystem/Munition.h"

namespace orxonox
{
    class _PickupExport MunitionContainer : public BaseObject
    {
        public:

            MunitionContainer(Context* context);
            virtual ~MunitionContainer();

            virtual void XMLPort(Element& xmlelement, orxonox::XMLPort::Mode mode) override;

            inline const std::string& getMunitionName() const
                { return this->munitionName_; }
            inline int getMunitionAmount() const
                { return this->munitionAmount_; }
            inline int getMagazinesAmount() const
                { return this->magazinesAmount_; }
            inline SubclassIdentifier<Munition> getMunitionType() const
                { return munitionType_; }            

        protected:
            void setMunitionName(const std::string& munitionName);
            void setMunitionAmount(int munitionAmount);
            void setMagazinesAmount(int magazinesAmount_);

        private:
            SubclassIdentifier<Munition> munitionType_; //!< Indentifier of the munition type.
            std::string munitionName_; //!< String containing the class name of the munition type (e.g. "LaserMunition")
            int munitionAmount_; //!< The amount of singe bullets added
            int magazinesAmount_; //!< The amount of full magazines added

    };    
}

#endif // _MunitionContainer_H__
