/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#ifndef _DivisionController_H__
#define _DivisionController_H__

#include "controllers/ActionpointController.h"



namespace orxonox
{
    /**
        @note
        ActionpointController will not work, if there is no MasterController in the level!
        All the demos are in a file called AITest.oxw. In the menu look for New AI Testing Level.
    */
    class _OrxonoxExport DivisionController : public ActionpointController
    {
        public:
            //----[language demanded functions]----            
                DivisionController(Context* context);

                virtual ~DivisionController();
            //----[/language demanded functions]----            

            //----[orxonox demanded functions]----
                virtual void tick(float dt); 
            //----[orxonox demanded functions]----

            //----[own functions]----
                virtual bool setFollower(ActionpointController* newFollower);
                virtual bool setWingman(ActionpointController* newWingman);
                virtual bool hasWingman();
                virtual bool hasFollower();
                
            //----[/own functions]----
            virtual void stayNearProtect();

        protected:
            //----action must only be managed by this----
            virtual void action(); //<! action() is called in regular intervals managing the bot's behaviour.

        private:
            //----private variables-----
            Timer actionTimer_; //<! Regularly calls action().
   

    };
}

#endif /* _DivisionController_H__ */
