/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#include "DivisionController.h"
#include "infos/PlayerInfo.h"

namespace orxonox
{

    RegisterClass(DivisionController);

    //Leaders share the fact that they have Wingmans
    DivisionController::DivisionController(Context* context) : ActionpointController(context)
    {
        RegisterObject(DivisionController);
        this->setFormationMode(FormationMode::DIAMOND);
        this->target_ = 0;
        this->myFollower_ = 0;
        this->myWingman_ = 0;
    }

    DivisionController::~DivisionController()
    {
        for (size_t i = 0; i < this->actionpoints_.size(); ++i)
        {
            if(this->actionpoints_[i])
                this->actionpoints_[i]->destroy();
        }
        this->parsedActionpoints_.clear();
        this->actionpoints_.clear();
    } 
    void DivisionController::tick(float dt)
    {   
        if (!this->isActive())
            return;   
        
        SUPER(DivisionController, tick, dt);
        
    }
    void DivisionController::action()
    {   
        if (!this || !this->getControllableEntity() || !this->isActive())
            return;
        
        ActionpointController::action();
        if (!this || !this->getControllableEntity())
            return;
        if (!(this->parsedActionpoints_.empty() && this->loopActionpoints_.empty()))
        {
            //when this dies, its follower will execute all its actionpoints, if follower dies before this, wingman will do this
            if (this->myFollower_)
            {
                this->myFollower_->takeActionpoints(this->parsedActionpoints_, this->loopActionpoints_, this->bLoop_);
            }
            else if (this->myWingman_)
            {
                this->myWingman_->takeActionpoints(this->parsedActionpoints_, this->loopActionpoints_, this->bLoop_);
            }    
        }

        
    }
    //I wanted to do it different here, but at this point I think nothing will change if I delete that method
    void DivisionController::stayNearProtect()
    {
        ActionpointController::stayNearProtect();
    }
    
    bool DivisionController::setWingman(ActionpointController* newWingman)
    {
        if (!this->myWingman_)
        {
            this->myWingman_ = newWingman;
            if (!this->hasFollower())
                newWingman->takeActionpoints (this->parsedActionpoints_, this->loopActionpoints_, this->bLoop_);
            return true;
        }
        else
        {
            return false;
        }
    }
    bool DivisionController::setFollower(ActionpointController* newFollower)
    {
        if (!this->myFollower_)
        {
            this->myFollower_ = newFollower;
            if (this->hasWingman())
            {
                this->myWingman_->takeActionpoints (std::vector<Point>(), std::vector<Point>(), false);
            }

            newFollower->takeActionpoints (this->parsedActionpoints_, this->loopActionpoints_, this->bLoop_);
            
            return true;
        }
        else
        {
            return false;
        }
    }
    bool DivisionController::hasWingman()
    {
        if (this->myWingman_)
            return true;
        else
            return false;
    }
    bool DivisionController::hasFollower()
    {
        if (this->myFollower_)
            return true;
        
        return false;
    }

}
