/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#ifndef _SectionController_H__
#define _SectionController_H__

#include "controllers/ActionpointController.h"


namespace orxonox
{
    /**
        @note
        ActionpointController will not work, if there is no MasterController in the level!
        All the demos are in a file called AITest.oxw. In the menu look for New AI Testing Level.
    */
    class _OrxonoxExport SectionController : public ActionpointController
    {
        public:
            //----[language demanded functions]----            
                SectionController(Context* context);

                virtual ~SectionController();
            //----[/language demanded functions]----
            
            //----[orxonox demanded functions]----
                virtual void tick(float dt); 
            //----[/orxonox demanded functions]----
            
            //----[own functions]----
                ActionpointController* findNewDivisionLeader();

                virtual bool setWingman(ActionpointController* newWingman);
                virtual bool hasWingman();
                virtual bool hasFollower()
                    { return false; }
                void chooseTarget();
            //----[/own functions]----

        protected:       
            //----action must only be managed by this----     
                virtual void action(); //<! action() is called in regular intervals by MasterController managing the bot's behaviour.
                Vector3 getFormationPosition ();
                void keepFormation();
        private:
            //----private variables-----
                bool bFirstAction_;
                
    };
}

#endif /* _SectionController_H__ */
