/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDHealthBar_H__
#define _HUDHealthBar_H__

#include "overlays/OverlaysPrereqs.h"

#include "util/Math.h"
#include "tools/interfaces/Tickable.h"
#include "overlays/OverlayText.h"
#include "HUDBar.h"

namespace orxonox
{
    class _OverlaysExport HUDHealthBar : public HUDBar, public Tickable
    {
        public:
            HUDHealthBar(Context* context);
            virtual ~HUDHealthBar();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void tick(float dt) override;
            virtual void changedOwner() override;
            virtual void changedOverlayGroup() override;
            virtual void changedVisibility() override;
            virtual void changedName() override;

            inline void setTextFont(const std::string& font)
                { if (!font.empty()) { this->textoverlay_->setFont(font); } }
            inline const std::string& getTextFont() const
                { return this->textoverlay_->getFont(); }

            void setTextColour(const ColourValue& colour);
            inline const ColourValue& getTextColour() const
                { return this->textoverlay_->getColour(); }

            void setTextUseBarColour(bool bUseBarColour);
            inline bool getTextUseBarColour() const
                { return this->bUseBarColour_; }

            inline void setTextAlignment(OverlayText::Alignment alignment)
                { this->textoverlay_->setAlignment(alignment); }
            inline OverlayText::Alignment getTextAlignment() const
                { return this->textoverlay_->getAlignment(); }

            void setTextAlignmentString(const std::string& alignment)
                { this->textoverlay_->setAlignmentString(alignment); }
            std::string getTextAlignmentString() const
                { return this->textoverlay_->getAlignmentString(); }

            inline void setTextVisible(bool bVisible)
                { this->textoverlay_->setVisible(bVisible); }
            inline bool getTextVisible() const
                { return this->textoverlay_->isVisible(); }

            inline void setTextScale(float scale)
                { this->textScale_ = scale;
                  positionText();
                }
            inline float getTextScale() const
                { return this->textScale_; }

            inline void setTextPickPoint(const Vector2& pickpoint)
                { this->textoverlay_->setPickPoint(pickpoint); }
            inline Vector2 getTextPickPoint() const
                { return this->textoverlay_->getPickPoint(); }

            inline void setTextOffset(const Vector2& position)
                { this->textOffset_ = position;
                  this->positionText();
                }
            inline Vector2 getTextOffset() const
                { return this->textOffset_; }

            inline void setTextRotation(const Degree& angle)
                { this->textoverlay_->setRotation(angle); }
            inline const Degree& getTextRotation() const
                { return this->textoverlay_->getRotation(); }

            inline void setTextSpaceWidth(float width)
                { this->textoverlay_->setSpaceWidth(width); }
            inline float getTextSpaceWidth() const
                { return this->textoverlay_->getSpaceWidth(); }

            inline void setHealthBarOwner(Pawn* owner)
                { this->owner_ = owner; }
        protected:
            virtual void positionChanged();
            virtual void sizeChanged();
        private:
            virtual void positionText();
            WeakPtr<Pawn> owner_;
            StrongPtr<OverlayText> textoverlay_;
            bool bUseBarColour_;
            ColourValue textColour_;
            Vector2 textOffset_;
            float textScale_;
    };
}
#endif /* _HUDHealthBar_H__ */
