/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#include "HUDWeapon.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "core/class/Super.h"

namespace orxonox
{
    RegisterClass(HUDWeapon);

    HUDWeapon::HUDWeapon(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(HUDWeapon);

        weaponModeHUDActualSize_ = Vector2(0.0f,0.0f);

        weaponModes_ = NULL;
        weaponIndex_ = 0;
        hudWeaponModes_.clear();

        overlayElement_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", "HUDWeapon" + getUniqueNumberString()));
        overlayElement_->setMaterialName("Orxonox/WSHUD_Weapon");
        overlayElement_->setPosition(0.0f,0.0f);
        overlayElement_->setDimensions(1.0f,1.0f);
        this->background_->addChild(overlayElement_);
    }

    HUDWeapon::~HUDWeapon()
    {
        if (this->isInitialized())
        {
            destroyHUDChilds();
        }
    }

    void HUDWeapon::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HUDWeapon, XMLPort, xmlelement, mode);

        /*XMLPortParam(HUDWeapons, "sensitivity", setRadarSensitivity, getRadarSensitivity, xmlelement, mode);
        XMLPortParam(HUDWeapons, "halfDotSizeDistance", setHalfDotSizeDistance, getHalfDotSizeDistance, xmlelement, mode);*/
    }

    void HUDWeapon::tick(float dt)
    {
        SUPER(HUDWeapon, tick, dt);

        if (!weapon_)
        {
            // TODO: destroy this HUD id the Weapon does no more exist. (Wehen the weak pointer is NULL)
        }
    }    

    void HUDWeapon::positionChanged()
    {
        OrxonoxOverlay::positionChanged();

        positionHUDChilds();
    }

    void HUDWeapon::sizeChanged()
    {
        OrxonoxOverlay::sizeChanged();

        positionHUDChilds();
    }

    void HUDWeapon::changedOwner()
    {
        SUPER(HUDWeapon, changedOwner);

        this->owner_ = orxonox_cast<Pawn*>(this->getOwner());

        updateWeaponModeList();
    }

    void HUDWeapon::changedOverlayGroup()
    {
        SUPER(HUDWeapon, changedOverlayGroup);
    }   

    void HUDWeapon::changedVisibility()
    {
        SUPER(HUDWeapon, changedVisibility);

        bool visible = this->isVisible();

        for (std::vector<WeakPtr<HUDWeaponMode> >::iterator it = hudWeaponModes_.begin(); it != hudWeaponModes_.end(); ++it)
        {
            (*it)->changedVisibility(); //inform all Child Overlays that our visibility has changed
            (*it)->setVisible(visible);
        }
    }

    void HUDWeapon::changedName()
    {
        SUPER(HUDWeapon, changedName);
    }

    void HUDWeapon::setWeapon(Weapon* weapon)
    {
        weapon_ = weapon;

        if (!weapon_)
        {
            return;
        }

        updateWeaponModeList();
    }

    void HUDWeapon::updateWeaponModeList()
    {
        if (owner_ == NULL || weapon_ == NULL)
        {
            return;
        }
            
        destroyHUDChilds();

        weaponModes_ = weapon_->getAllWeaponmodes();

        updateSize();
        createHUDChilds();
        positionHUDChilds();
    }  

    void HUDWeapon::createHUDChilds()
    {
        if (weaponModes_ == NULL)
        {
            return;
        }

        int positionIndex = 0;

        for (std::multimap<unsigned int, WeaponMode*>::iterator it = weaponModes_->begin(); it != weaponModes_->end(); ++it)
        {
            HUDWeaponMode* hudWeaponMode = new HUDWeaponMode(this->getContext());
            hudWeaponMode->setOwner(owner_);
            hudWeaponMode->setOverlayGroup(this->getOverlayGroup());
            hudWeaponMode->setVisible(this->isVisible());
            hudWeaponMode->setWeaponMode(it->second);
            hudWeaponMode->setWeaponIndex(this->weaponIndex_);                    
            hudWeaponMode->setAspectCorrection(false);
            hudWeaponMode->setPickPoint(Vector2(0.0f,0.0f));

            hudWeaponModes_.push_back(hudWeaponMode);

            ++ positionIndex;
        }
    }      

    void HUDWeapon::positionHUDChilds()
    {
        int positionIndex = 0;

        for (std::vector<WeakPtr<HUDWeaponMode> >::iterator it = hudWeaponModes_.begin(); it != hudWeaponModes_.end(); ++it)
        {
            (*it)->setPositionOffset(this->positionOffset_);
            (*it)->setWeaponModeIndex(positionIndex);
            (*it)->setWeaponIndex(this->weaponIndex_);
            (*it)->setWeaponModeHUDActualSize(this->weaponModeHUDActualSize_);

            ++ positionIndex;
        }
    }  

    void HUDWeapon::destroyHUDChilds()
    {
        for (std::vector<WeakPtr<HUDWeaponMode> >::iterator it = hudWeaponModes_.begin(); it != hudWeaponModes_.end(); ++it)
        {
            (*it)->destroy();
        } 

        hudWeaponModes_.clear();
    }

    void HUDWeapon::updateSize()
    {
        if (weaponModes_ != NULL)
        {
            this->setSize(Vector2(weaponModeHUDActualSize_.x,weaponModeHUDActualSize_.y*weaponModes_->size()));
            updatePosition();
        }        
    }

    void HUDWeapon::updatePosition()
    {
        if (weaponModes_ != NULL)
        {
            this->setPosition(Vector2(weaponModeHUDActualSize_.x*weaponIndex_,0.0f) + this->positionOffset_);
        }        
    }       
}
