/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverWall.h
    @brief See .cc-file for further information
    @ingroup Hover
*/

#ifndef _HoverWall_H__
#define _HoverWall_H__

#include "HoverPrereqs.h"
#include "objects/ObjectsPrereqs.h"

#include "worldentities/StaticEntity.h"

namespace orxonox
{
    class _HoverExport HoverWall : public StaticEntity
    {
        public:
            HoverWall(Context* context);
            virtual ~HoverWall();

            void init(int x, int y, int cellSize, int cellHeight, int orientation);

        private:
            Model* model_;
            BoxCollisionShape* cs_;
    };
}

#endif /* _HoverWall_H__ */
