/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *
 */

 /**
    @file TimeHUD.h
    @brief Declaration of the TimeHUD class.
*/

#ifndef _TimeHUD_H__
#define _TimeHUD_H__

#include "HoverPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "overlays/OverlayText.h"

namespace orxonox
{
    class _HoverExport TimeHUD : public OverlayText, public Tickable
    {
        public:
            TimeHUD(Context* context);

            virtual void tick(float dt);
            virtual void changedOwner();

            /// sets if the clock is running
            inline void setRunning(bool running)
                { this->running_ = running; }
            /// returns if the clock is running
            inline bool isRunning() const
                { return this->running_; }

            void reset();

        private:
            Hover* hoverGame_;
            float time_;
            bool running_;
    };
}
#endif /* _TimeHUD_H__ */
