/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverFlag.cc
    @brief The Flags that are being set in the Hover Minigame They support two coordinates from 0-9 each
*/

#include "HoverFlag.h"
#include "HoverShip.h"

#include "core/CoreIncludes.h"

#include "graphics/Model.h"
#include "objects/collisionshapes/BoxCollisionShape.h"
#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(HoverFlag);

    HoverFlag::HoverFlag(Context* context) : StaticEntity(context)
    {
        RegisterObject(HoverFlag);
        model_ = NULL;
        cs_ = NULL;
    }

    /**
    @brief
        Constructor that expects two coordinate-values in the range 0-9
    @param xCoordinate
        X-Coordinate of the flage, 0-9, origin is bottom left
    @param yCoordinate
        Y-Coordinate of the flage, 0-9, origin is bottom left
    */
    HoverFlag::HoverFlag(Context* context, int xCoordinate, int yCoordinate, int cellSize) : StaticEntity(context)
    {
        RegisterObject(HoverFlag);
        enableCollisionCallback();
        model_ = NULL;
        cs_ = NULL;

        model_ = new Model(context);
        model_->setMeshSource("ss_flag_eu.mesh");
        model_->setScale3D(Vector3(5, 5, 5));
        model_->setPosition(Vector3(xCoordinate*cellSize*1.0f + cellSize/2,10.0f,yCoordinate*cellSize*1.0f + cellSize/2));

        this->attach(model_);

        this->enableCollisionCallback();
        this->setCollisionResponse(true);
        this->setCollisionType(Static);

        cs_ = new BoxCollisionShape(context);
        cs_->setHalfExtents(Vector3(5, 5, 5));
        cs_->setPosition(Vector3(xCoordinate*cellSize*1.0f + cellSize/2,0.0f,yCoordinate*cellSize*1.0f + cellSize/2));

        this->attachCollisionShape(cs_);
        this->collided_ = false;

    }

    /**
    @brief
        Destructor.
    */
    HoverFlag::~HoverFlag()
    {

    }

    /**
    @brief
        Checks if the Hovership collided with the flag
    */
    bool HoverFlag::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint)
    {
        if(otherObject->isA(Class(HoverShip)))
            collided_ = true;
        return false;
    }
}
