/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      Cyrill Burgener
 *
 */

/**
    @file Hover.cc
    @brief Implementation of the Hover class. Sets up the whole Minigame
*/

#include "Hover.h"

#include "HoverOrigin.h"
#include "HoverWall.h"
#include "HoverFlag.h"
#include "MazeGenerator.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterUnloadableClass(Hover);

    Hover::Hover(Context* context) : Gametype(context)
    {
        RegisterObject(Hover);

        this->origin_ = NULL;
        this->flags_ = 1;
        this->firstTick_ = true;

        this->setHUDTemplate("HoverHUD");
    }

    void Hover::tick(float dt)
    {
        SUPER(Hover, tick, dt);

        if(this->firstTick_ && this->origin_)
        {
            this->firstTick_ = false;

            int numCells = this->origin_->getNumCells();
            int cellSize = this->origin_->getCellSize();
            int cellHeight = this->origin_->getCellHeight();

            MazeGenerator generator(numCells);
            generator.generateMaze();
            generator.renderMaze();

            int* levelcode = generator.getLevelcode();

            //Outer Walls
            for(int i = 0; i<numCells; i++){
                new HoverWall(origin_->getContext(), 0,        i+1,      cellSize, cellHeight, 1);
                new HoverWall(origin_->getContext(), numCells, i+1,      cellSize, cellHeight, 1);
                new HoverWall(origin_->getContext(), i+1,      0,        cellSize, cellHeight, 2);
                new HoverWall(origin_->getContext(), i+1,      numCells, cellSize, cellHeight, 2);
            }

            //Generate inner Walls according to levelcode
            for(int y=0; y<numCells; y++){
                for(int x=0; x<numCells; x++){
                    switch(levelcode[ y * numCells + x ]){
                        case 1: new HoverWall(origin_->getContext(), x+1, numCells-y, cellSize, cellHeight, 1);
                                break;
                        case 3: new HoverWall(origin_->getContext(), x+1, numCells-y, cellSize, cellHeight, 1);
                        case 2: new HoverWall(origin_->getContext(), x+1, numCells-y, cellSize, cellHeight, 0);
                        default: break;
                    }
                }   
            }

            //Generate 5 flags randomly
            for ( int i = 0; i < 5; i++ )
                flagVector_.push_back(new HoverFlag(origin_->getContext(), rand()%numCells, rand()%numCells, cellSize));

            flags_ = flagVector_.size();

        }//firsttick end

        // Check if ship collided with one of the flags
        for ( unsigned int i = 0; i < flagVector_.size(); i++ ){
            if(flagVector_[i]->getCollided()){
                flagVector_[i]->destroyLater();
                flagVector_.erase (flagVector_.begin()+i);
            }
        }
        flags_ = flagVector_.size();
    }
}
