/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Master of Desaster:
 *      Manuel Meier
 *   Co-authors:
 *      Cyrill Burgener
 *
 */

/**
    @file MazeGenerator.h
    @ingroup Hover
*/

#ifndef _MazeGenerator_H__
#define _MazeGenerator_H__

#include "HoverPrereqs.h"

namespace orxonox
{
    enum eDirection
    {
        eDirection_Invalid = 0,
        eDirection_Up      = 1,
        eDirection_Right   = 2,
        eDirection_Down    = 4,
        eDirection_Left    = 8
    }; 

    class _HoverExport MazeGenerator
    {
        public:
            MazeGenerator(int numCells);

            void generateMaze();
            void renderMaze();
            void mazeOut();
            void levelOut();

            int* getLevelcode() const
                { return this->levelcode_; }

        private:
            bool isDirValid( eDirection Dir );
            eDirection getDirection();

            int cellIdx();
            int randomInt();
            int randomInt4();

            int numCells_;
            int* levelcode_;
            unsigned char* maze_;

            // current traversing position
            int ptX_;
            int ptY_;

            int headingX_[9];
            int headingY_[9];
            int mask_[9];
    };
}

#endif /* _MazeGenerator_H__ */
