/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Master of Desaster:
 *      Manuel Meier
 *   Co-authors:
 *      Cyrill Burgener
 *
 */

/**
    @file Hover.h
    @brief Gametype. For more information see .cc file
    @ingroup Hover
*/

#ifndef _Hover_H__
#define _Hover_H__

#include "HoverPrereqs.h"
#include "HoverOrigin.h" 

#include "gametypes/Gametype.h"
#include "core/EventIncludes.h"
#include "core/command/Executor.h"
#include "core/config/ConfigValueIncludes.h"

#include "gamestates/GSLevel.h"
#include "chat/ChatManager.h"
#include <vector>

// ! HACK
#include "infos/PlayerInfo.h"

#include "core/command/ConsoleCommand.h"

#include "tools/Timer.h"



namespace orxonox
{
    class _HoverExport Hover : public Gametype
    {
       public:
            Hover(Context* context);

            virtual void start();
            virtual void end();

            virtual void tick(float dt);          

            void setOrigin(HoverOrigin* origin)
                { this->origin_ = origin; }

            int getFlags();

        private:
            WeakPtr<HoverOrigin> origin_;
            std::vector<HoverFlag*> flagVector_;
            int flags_;
            bool firstTick_;
    };
}

#endif /* _Hover_H__ */
