/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverFlag.h
    @brief See .cc File
    @ingroup Hover
*/

#ifndef _HoverFlag_H__
#define _HoverFlag_H__

#include "HoverPrereqs.h"
#include "util/Math.h"
#include "worldentities/StaticEntity.h"
#include "graphics/Model.h"    
#include "objects/collisionshapes/BoxCollisionShape.h"


namespace orxonox
{
    class _HoverExport HoverFlag : public StaticEntity
    {
        public:
            HoverFlag(Context* context);
            HoverFlag(Context* context, int xCoordinate, int yCoordinate);
            virtual bool collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint);            
            virtual ~HoverFlag();
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
            bool getCollided();
            void setCollided(bool setValue);

        private:
            Model* model_;
            BoxCollisionShape* cs_;
            bool collided_;

    };
}

#endif /* _HoverFlag_H__ */
