/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *
 */

 /**
    @file FlagHUD.h
    @brief Declaration of the FlagHUD class.
*/

#ifndef _FlagHUD_H__
#define _FlagHUD_H__

#include "overlays/OverlaysPrereqs.h"

#include "util/Math.h"
#include "util/OgreForwardRefs.h"
#include "core/BaseObject.h"
#include "overlays/OrxonoxOverlay.h"
#include "Hover.h"

namespace orxonox
{
    class _HoverExport FlagHUD : public OrxonoxOverlay , public Tickable
    {
    public:
        FlagHUD(Context* context);
        virtual ~FlagHUD();

        virtual void tick(float dt);
        virtual void changedOwner();

        virtual void setFlagCount(int flagCount);


    private:
        Hover* hoverGame;
        Ogre::PanelOverlayElement* panel_;
        int flagCount_;
    };
}
#endif /* _FlagHUD_H__ */
