/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *
 */

 /**
    @file TimeHUD.h
    @brief Declaration of the TimeHUD class.
*/

#ifndef _TimeHUD_H__
#define _TimeHUD_H__

#include "hover/HoverPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "overlays/OverlayText.h"

namespace orxonox
{
    class _HoverExport TimeHUD : public OverlayText, public Tickable
    {
        public:
            TimeHUD(Context* context);

            virtual void tick(float dt);
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
            virtual void changedOwner();

            virtual void setRunning(bool running);
            virtual bool isRunning();
            virtual void reset();

        private:
            Hover* hoverGame;
            float _time;
            bool _running;
    };
}
#endif /* _TimeHUD_H__ */
