/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *
 */

/**
    @file FlagHUD.cc
    @brief Implementation of the FlagHUD
*/

#include "FlagHUD.h"

#include <OgreOverlayManager.h>
#include <OgreMaterialManager.h>
#include <OgrePanelOverlayElement.h>

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(FlagHUD);

    FlagHUD::FlagHUD(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(FlagHUD);

        this->panel_ = static_cast<Ogre::PanelOverlayElement*>(Ogre::OverlayManager::getSingleton()
            .createOverlayElement("Panel", "FlagHUD_Panel_" + getUniqueNumberString()));
        this->panel_->setMaterialName("Hover/Flag");
        this->overlay_->add2D(this->panel_);

        this->flagCount_ = 5;
        setFlagCount(5);
    }

/**
    @brief Sets the amount of flags displayed, once zero it does not reappear
    @param flagCount
*/
    void FlagHUD::setFlagCount(int flagCount) {
        if(flagCount == 0){
            this->panel_->hide();
            return;
        }
        this->panel_->setDimensions(
            this->panel_->_getRelativeWidth() / ((float) flagCount_) * ((float) flagCount),
            this->panel_->_getRelativeHeight()
            );
        this->panel_->setTiling(flagCount, 1.0f);

        this->flagCount_ = flagCount;
    }

    void FlagHUD::tick(float dt)
    {
        SUPER(FlagHUD, tick, dt);

            setFlagCount(this->hoverGame->getFlags());
        
    }

    void FlagHUD::changedOwner()
    {
        SUPER(FlagHUD, changedOwner);

        if (this->getOwner() && this->getOwner()->getGametype())
        {
            this->hoverGame = orxonox_cast<Hover*>(this->getOwner()->getGametype());
        }
        else
        {
            this->hoverGame = 0;
        }
    }

    FlagHUD::~FlagHUD()
    {
        if (this->isInitialized())
        {
            Ogre::OverlayManager::getSingleton().destroyOverlayElement(this->panel_);
        }
    }
}
