/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverFlag.cc
    @brief All platforms in this minigame inherit from this class. The basic functions of a platform (interact with figure) is implemented here. Special functions are implemented in the specialized classes.
*/

#include "HoverFlag.h"
#include "HoverShip.h"

#include "core/CoreIncludes.h"
#include "core/GameMode.h"
#include "graphics/Model.h"
#include "gametypes/Gametype.h"




#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(HoverFlag);

    HoverFlag::HoverFlag(Context* context) : StaticEntity(context)
    {
        RegisterObject(HoverFlag);
        model_ = NULL;
        cs_ = NULL;
    }

    HoverFlag::HoverFlag(Context* context, int xCoordinate, int yCoordinate) : StaticEntity(context)
    {
        RegisterObject(HoverFlag);
        enableCollisionCallback();
        model_ = NULL;
        cs_ = NULL;

        model_ = new Model(context);
        model_->setMeshSource("ss_flag_eu.mesh");
        model_->setScale3D(Vector3(5, 5, 5));
        model_->setPosition(Vector3(xCoordinate*100 + 50,10,yCoordinate*100 + 50));

        this->attach(model_);

        this->enableCollisionCallback();
        this->setCollisionResponse(true);
        this->setCollisionType(Static);

        cs_ = new BoxCollisionShape(context);
        cs_->setHalfExtents(Vector3(5, 5, 5));
        cs_->setPosition(Vector3(xCoordinate*100 + 50,0,yCoordinate*100 + 50));

        this->attachCollisionShape(cs_);
        this->collided_ = false;

    }

    /**
    @brief
        Destructor.
    */
    HoverFlag::~HoverFlag()
    {

    }

    //xml port for loading height and width of the platform
    void HoverFlag::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HoverFlag, XMLPort, xmlelement, mode);
    }




    /**
    @brief
        Is called every tick.
        Handles the movement of the ball and its interaction with the boundaries and bats.
    @param dt
        The time since the last tick.
    */
    void HoverFlag::tick(float dt)
    {
        SUPER(HoverFlag, tick, dt);
        
    }

    bool HoverFlag::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint)
    {
        if(otherObject->isA(Class(HoverShip)))
            collided_ = true;
        return false;
    }

    bool HoverFlag::getCollided(){
        return collided_;
    }

    void HoverFlag::setCollided(bool setValue){
        collided_ = setValue;
    }
    
    
}
