/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MineProjectile.h
    @brief Definition of the MineProjectile class.
*/

#ifndef _MineProjectile_H__
#define _MineProjectile_H__

#include "weapons/WeaponsPrereqs.h"
#include "tools/Timer.h"
#include "worldentities/MovableEntity.h"
#include "objects/collisionshapes/SphereCollisionShape.h"
#include "objects/triggers/DistanceTrigger.h"
#include "BasicProjectile.h"

namespace orxonox
{

    /**
    @brief
        TODO
    @ingroup WeaponsProjectiles
    */
    class _WeaponsExport MineProjectile : public MovableEntity, public BasicProjectile
    {
        public:
            MineProjectile(Context* context);
            virtual ~MineProjectile();

            virtual void setMaxTimeUntilExplosion(float maxTimeUntilExplosion);
            virtual void setTimeUntilActivation(float timeUntilActivation);
            void destructionEffect();

        private:
            bool bActive_; // The mine can only explode if it is active
            float maxTimeUntilExplosion_;
            float timeUntilActivation_;
            Timer activationTimer_;
            Timer explodeTimer_;
            Model* modelCore_;
            Model* modelRing1_;
            Model* modelRing2_;
            Model* modelRing3_;
            Model* modelRing4_;
            MovableEntity* rings1_;
            MovableEntity* rings2_;
            MovableEntity* core_;
            ParticleEmitter* emitter_;

            WeakPtr<SphereCollisionShape> collisionShape_; // The collision shape of the projectile.
            WeakPtr<DistanceTrigger> distanceTrigger_;

            virtual void Activate();
            virtual void Explode();
    };
}

#endif /* _MineProjectile_H__ */
