/**
 * Originally from http://www.ogre3d.org/tikiwiki/BulletDebugDrawer&structure=Cookbook
 * This source code is released into the Public Domain.
 *
 * Modified by Fabian 'x3n' Landau by using DebugDrawer and Orxonox specific utilities (e.g. output).
 */

#ifndef _BulletDebugDrawer_H__
#define _BulletDebugDrawer_H__

#include "tools/ToolsPrereqs.h"

#include <btBulletCollisionCommon.h>
#include <OgreFrameListener.h>
#include <OgreVector3.h>
#include <OgreColourValue.h>

namespace orxonox
{
    class _ToolsExport BulletDebugDrawer : public btIDebugDraw, public Ogre::FrameListener
    {
        public:
            BulletDebugDrawer(Ogre::SceneManager* sceneManager);
            ~BulletDebugDrawer();
            virtual void drawLine(const btVector3& from, const btVector3& to, const btVector3& color) override;
//            virtual void drawTriangle(const btVector3& v0, const btVector3& v1, const btVector3& v2, const btVector3& color, btScalar) override;
            virtual void drawSphere (const btVector3& p, btScalar radius, const btVector3& color) override;
            virtual void drawSphere(btScalar radius, const btTransform& transform, const btVector3& color) override;
            virtual void drawBox(const btVector3& bbMin, const btVector3& bbMax, const btVector3& color) override;
            virtual void drawBox(const btVector3& bbMin, const btVector3& bbMax, const btTransform& trans, const btVector3& color) override;
            virtual void drawCylinder(btScalar radius, btScalar halfHeight, int upAxis, const btTransform& transform, const btVector3& color) override;
            virtual void drawCone(btScalar radius, btScalar height, int upAxis, const btTransform& transform, const btVector3& color) override;
//            virtual void drawPlane(const btVector3& planeNormal, btScalar planeConst, const btTransform& transform, const btVector3& color) override;

            virtual void drawContactPoint(const btVector3& PointOnB, const btVector3& normalOnB, btScalar distance, int lifeTime, const btVector3& color) override;

            virtual void reportErrorWarning(const char* warningString) override;
            virtual void draw3dText(const btVector3& location, const char* textString) override;

            virtual void setDebugMode(int debugMode) override;
            virtual int getDebugMode() const override;

            void configure(bool bFill, float fillAlpha);

        protected:
            virtual bool frameStarted(const Ogre::FrameEvent& evt) override;
            virtual bool frameEnded(const Ogre::FrameEvent& evt) override;

        private:
            struct ContactPoint
            {
                Ogre::Vector3 from;
                Ogre::Vector3 to;
                Ogre::ColourValue color;
                size_t dieTime;
            };

            bool bFill_;
            DebugDrawer* drawer_;

            DebugDrawModes mDebugMode;
            std::vector<ContactPoint>* mContactPoints;
            std::vector<ContactPoint> mContactPoints1;
            std::vector<ContactPoint> mContactPoints2;
    };
}

#endif /* _BulletDebugDrawer_H__ */
