/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MineGun.h
    @brief Definition of the MineGun class.
*/

#ifndef _MineGun_H__
#define _MineGun_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        A Mine that explodes when a ship is too close
    @author
        Fabien Vultier
    @ingroup WeaponsWeaponModes
    */
    class _WeaponsExport MineGun : public WeaponMode
    {
        public:
            MineGun(Context* context);
            virtual ~MineGun();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
            virtual void fire();
            inline void setLifeTime(float lifeTime)
                { this->lifeTime_ = lifeTime; }
            inline float getLifeTime() const
                { return this->lifeTime_; }

       private:
            float speed_; //The speed of the fired projectile.
            float lifeTime_;

    };
}

#endif /* _MineGun_H__ */
