/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MineGun.cc
    @brief Implementation of the MineGun class.
*/

#include "MineGun.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"    
#include "weaponsystem/Weapon.h"
#include "weaponsystem/WeaponPack.h"
#include "weaponsystem/WeaponSystem.h"
#include "worldentities/pawns/Pawn.h"

#include "weapons/projectiles/MineProjectile.h"

namespace orxonox
{
    RegisterClass(MineGun);

    MineGun::MineGun(Context* context) : WeaponMode(context)
    {
        RegisterObject(MineGun);

        this->reloadTime_ = 1.0f;
        this->damage_ = 0.0f;
        this->speed_ = 0.0f;
        this->lifeTime_ = 7500.0f;

        this->setMunitionName("MineMunition");
        this->setDefaultSound("sounds/Weapon_LightningGun.ogg");
    }

    MineGun::~MineGun()
    {
    }

    /**
    @brief
        XMLPort for the MineGun. You can define how often the projectiles Mine, how many childs should be created per Mine, the spread and the time between two Mines.
    */
    void MineGun::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(MineGun, XMLPort, xmlelement, mode);
        XMLPortParam(MineGun, "Lifetime", setLifeTime, getLifeTime, xmlelement, mode);
    }

    /**
    @brief
        Fires the weapon. Creates a projectile and fires it.
    */
    void MineGun::fire()
    {
        MineProjectile* projectile = new MineProjectile(this->getContext());
        //projectile->setMaterial("Flares/energyflare");

        this->computeMuzzleParameters(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn()->getAimPosition());
        projectile->setOrientation(this->getMuzzleOrientation());
        projectile->setPosition(this->getMuzzlePosition());
        projectile->setVelocity(this->getMuzzleDirection() * this->speed_);

        // Pass important information to the projectile: Number of Mines, Number of childs, Mine time, spread and the damage reduction
        /*projectile->setNumberOfMines(getNumberOfMines());
        projectile->setNumberOfChilds(getNumberOfChilds());*/
        projectile->setLifeTime(getLifeTime());
        /*projectile->setSpread(getSpread());
        projectile->setDamageReduction(getDamageReduction());*/

        projectile->setShooter(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn());
        projectile->setDamage(this->getDamage());
        projectile->setShieldDamage(this->getShieldDamage());
        projectile->setHealthDamage(this->getHealthDamage());
    }
}
