/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file IceGunProjectile.h
    @brief Definition of the MineProjectile class.
*/

#ifndef _MineProjectile_H__
#define _MineProjectile_H__

#include "weapons/WeaponsPrereqs.h"

#include <string>
#include "tools/Timer.h"
#include "Projectile.h"

namespace orxonox
{

    /**
    @brief
        The MineProjectile is a projectile that may Mine up into many child projectiles.
    @author
        Fabien Vultier
    @ingroup WeaponsProjectiles
    */
    class _WeaponsExport MineProjectile : public Projectile
    {
        public:
            MineProjectile(Context* context);
            virtual ~MineProjectile() {}

            virtual void setLifeTime(float LifeTime);
            


        private:            
            float lifeTime_;
            Timer explodeTimer;

            virtual void Explode();            
    };
}

#endif /* _MineProjectile_H__ */
