/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MineProjectile.h
    @brief Implementation of the MineProjectile class.
*/

#include "MineProjectile.h"

#include "core/CoreIncludes.h"
#include "core/command/Executor.h"
#include "util/Convert.h"
#include "util/Math.h"

#include "core/CoreIncludes.h"
#include "graphics/Model.h"
#include "graphics/ParticleSpawner.h"
#include "Scene.h"
#include "core/command/Executor.h"
#include "tools/ParticleInterface.h"

namespace orxonox
{
    RegisterClass(MineProjectile);

    MineProjectile::MineProjectile(Context* context) : Projectile(context)
    {
        RegisterObject(MineProjectile);

        this->lifeTime_ = 1.0f;

        Model* model = new Model(this->getContext());
        model->setMeshSource("sphere.mesh");
        model->setScale(15.0);
        this->attach(model);
        model->setPosition(Vector3(0,0,0));
    }

    
    /**
    @brief
        This function starts a timer that will cause the projectile to Mine after a time defined by the argument @param LifeTime.        
    */
    void MineProjectile::setLifeTime(float lifeTime)
    {
        orxout() << lifeTime << endl;

        if (lifeTime >= 0)
        {
            this->lifeTime_ = lifeTime;
            this->explodeTimer.setTimer(this->lifeTime_, false, createExecutor(createFunctor(&MineProjectile::Explode, this)));
        }
        else
        {
            this->lifeTime_ = 0;
        }
    }


    /**
    @brief
        This is the setter function for the damageReduction_ variable. The value of the variable is bounded between 0 and 1.
    */


    /**
    @brief
        If this function is called the projectile Mines up into many child projectiles. The original projectiles does not get destroyed but it will never Mine up again.
    */
    void MineProjectile::Explode()
    {
        orxout() << "Explode" << endl;

        this->destroyLater();


    }
}
