/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MineMunition.h
    @brief Implementation of the MineMunition class.
*/

#include "MineMunition.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(MineMunition);

    MineMunition::MineMunition(Context* context) : Munition(context)
    {
        RegisterObject(MineMunition);

        this->maxMunitionPerMagazine_ = 1;
        this->maxMagazines_ = 100;
        this->magazines_ = 25;

        this->bUseSeparateMagazines_ = false;
        this->bStackMunition_ = true;

        this->bAllowMunitionRefilling_ = true;
        this->bAllowMultiMunitionRemovementUnderflow_ = false;
    }
}
