/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file IceGunProjectile.h
    @brief Definition of the IceGunProjectile class.
*/

#ifndef _IceGunProjectile_H__
#define _IceGunProjectile_H__

#include "weapons/WeaponsPrereqs.h"

#include <string>
#include "tools/Timer.h"
#include "BillboardProjectile.h"
#include "weapons/IceGunFreezer.h"

namespace orxonox
{

    /**
    @brief
        The IceGunProjectile is a projectile that attaches a IceGunFreezer to the hit object. This object gets slowed down by the IceGunFreezer.
    @author
        Fabien Vultier
    @ingroup WeaponsProjectiles
    */
    class _WeaponsExport IceGunProjectile : public Projectile
    {
        public:
            IceGunProjectile(Context* context);
            virtual ~IceGunProjectile();

            virtual void setFreezeTime(float freezeTime);
            virtual void setFreezeFactor(float freezeFactor);

        protected:
            virtual bool collidesAgainst(WorldEntity* otherObject, const btCollisionShape* cs, btManifoldPoint& contactPoint);
        private:
            ParticleEmitter* emitter_;
            float freezeTime_; //The duration of the freezing effect on a target
            float freezeFactor_; //The strength of the freezing effect
    };
}

#endif /* _IceGunProjectile_H__ */
