/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#include "DivisionController.h"


namespace orxonox
{

    RegisterClass(DivisionController);

    DivisionController::DivisionController(Context* context) : LeaderController(context)
    {
        RegisterObject(DivisionController);
        
        this->setFormationMode(FormationMode::DIAMOND);
        this->target_ = 0;
        this->myFollower_ = 0;
        this->myWingman_ = 0;
        this->actionTimer_.setTimer(ACTION_INTERVAL, true, createExecutor(createFunctor(&DivisionController::action, this)));
        this->rank_ = Rank::DIVISIONLEADER;


    }

    DivisionController::~DivisionController()
    {
      
    } 

    
    void DivisionController::tick(float dt)
    {   
        if (!this->isActive())
            return;
        if (this->bHasTargetPosition_)
        {
            this->moveToTargetPosition(dt);
        }
        else if (this->bLookAtTarget_)
        {
            this->lookAtTarget(dt);
        }
        if (bShooting_)
        {
            this->doFire();
        }
        
        SUPER(DivisionController, tick, dt);

    }
    void DivisionController::action()
    {
        this->maneuver();
        this->bShooting_ = this->canFire();
        

    }

    

    void DivisionController::setTargetPositionOfWingman()
    {
        if (!this->myWingman_)
            return;
        Vector3* targetRelativePositionOfWingman;
        switch (this->formationMode_){
            case FormationMode::WALL:
            {
                targetRelativePositionOfWingman = new Vector3 (400, 0, 0);  
                break;
            }
            case FormationMode::FINGER4: 
            {
                targetRelativePositionOfWingman = new Vector3 (400, 0, -200);  
                break;
            }
            case FormationMode::VEE: 
            {
                break;
            }
            case FormationMode::DIAMOND: 
            {
                targetRelativePositionOfWingman = new Vector3 (400, 0, -200);                  
                break;
            }
        }
        Quaternion orient = this->getControllableEntity()->getWorldOrientation();
        
        Vector3 targetAbsolutePositionOfWingman = ((this->getControllableEntity()->getWorldPosition()) + 
        (this->getControllableEntity()->getWorldOrientation()* (*targetRelativePositionOfWingman)));
        
        myWingman_->setTargetOrientation(orient);
        myWingman_->setTargetPosition(targetAbsolutePositionOfWingman);
       
    }
    void DivisionController::setTargetPositionOfFollower()
    {
        if (!this->myFollower_)
            return;
        this->myFollower_->setFormationMode(this->formationMode_);

        Vector3* targetRelativePositionOfFollower;
        switch (this->formationMode_){
            case FormationMode::WALL:
            {
                targetRelativePositionOfFollower = new Vector3 (-400, 0, 0);   
                break;
            }
            case FormationMode::FINGER4: 
            {
                targetRelativePositionOfFollower = new Vector3 (-400, 0, -200);   
                break;
            }
            case FormationMode::VEE: 
            {
                break;
            }
            case FormationMode::DIAMOND: 
            {
                targetRelativePositionOfFollower = new Vector3 (-400, 0, -200);                   
                break;
            }
        }
        Quaternion orient = this->getControllableEntity()->getWorldOrientation();
        
        Vector3 targetAbsolutePositionOfFollower = ((this->getControllableEntity()->getWorldPosition()) + 
        (this->getControllableEntity()->getWorldOrientation()* (*targetRelativePositionOfFollower)));
        
        myFollower_->setTargetOrientation(orient);
        myFollower_->setTargetPosition(targetAbsolutePositionOfFollower);
       
    }


    bool DivisionController::setWingman(CommonController* cwingman)
    {

        WeakPtr<WingmanController> wingman = orxonox_cast<WingmanController*>(cwingman);
        if (!this->myWingman_)
        {
            this->myWingman_ = wingman;
            return true;
        }
        else
        {
            return false;
        }
    
    }
    bool DivisionController::setFollower(LeaderController* myFollower)
    {
         if (!this->myFollower_)
        {
            this->myFollower_ = myFollower;
            return true;
        }
        else
        {
            return false;
        }
    }
    bool DivisionController::hasWingman()
    {
        if (this->myWingman_)
            return true;
        else
            return false;
    }
    bool DivisionController::hasFollower()
    {
        if (this->myFollower_)
            return true;
        else
            return false;
    }


    void DivisionController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(DivisionController, XMLPort, xmlelement, mode);

        //XMLPortParam(DivisionController, "target_", setTarget, getTarget, xmlelement, mode).defaultValues(100.0f);
    }

    
   

}
