/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#ifndef _CommonController_H__
#define _CommonController_H__


#include "controllers/Controller.h"
#include "worldentities/ControllableEntity.h"
#include "worldentities/pawns/Pawn.h"
#include "core/ClassTreeMask.h"


namespace orxonox
{

    namespace FormationMode
    {
        enum Value
        {
            VEE, FINGER4, DIAMOND, WALL
        };
    }
    namespace Rank
    {
        enum Value 
        { 
            NONE, SECTIONLEADER, DIVISIONLEADER, WINGMAN 
        };

    }
    //none for a formation flight without attacking, neutral when opponent and this have no 
    //advantage over each other, offensive when this spotted opponent first,
    //defensive otherwise
    namespace ManeuverType
    {
        enum Value 
        { 
            NONE, NEUTRAL, OFFENSIVE, DEFENCIVE 
        };

    }
    //none for a formation flight
    namespace Maneuver
    {
        enum Value
        {
            NONE, GUNSD, SCISSORS, COMBATSPREAD, DEFENSIVESPLIT, BREAK, BARRELROLL, SWOOP, IMMELMANN, 
            WINGOVER, LOWYOYO, HIGHYOYO, LAGDISPLACEMENTROLL
        };
    }


    class _OrxonoxExport CommonController : public Controller
    {

        public:
            static const float hardcoded_projectile_speed = 750;

            static const float ACTION_INTERVAL = 1.0f;


            CommonController(Context* context);
            virtual ~CommonController();





            virtual void setFormationMode(FormationMode::Value val)
                { this->formationMode_ = val; }
            inline FormationMode::Value getFormationMode() const
                { return this->formationMode_; }
            virtual void setFormationModeXML(std::string val);
            virtual std::string getFormationModeXML();

            virtual void setRank(Rank::Value val)
                { this->rank_ = val; }
            inline Rank::Value getRank() const
                { return this->rank_; }

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);



            virtual bool setWingman(CommonController* wingman);
            virtual bool hasWingman();

            void setTarget(ControllableEntity* target);
            bool hasTarget();
            ControllableEntity* getTarget();
            void setTargetOrientation(const Quaternion& orient);
            void setTargetOrientation(ControllableEntity* target);
            void setTargetPosition(const Vector3& target);

            /*void spin();
            void turn180();*/


        protected:
            void dodge(Vector3& thisPosition, Vector3& diffUnit);
            int counter;
            void moveToPoint(const Vector3& relativeTargetPosition, float angleRoll);
            bool moveAndRoll(float dt);

            void moveToPosition(const Vector3& target, float dt);
            void moveToTargetPosition(float dt);
            //enum Mode {ROCKET, ATTACK, MOVE, HOLD};//TODO; implement DEFENCE, MOVING modes

            //Mode mode_;
            void copyOrientation(const Quaternion& orient, float dt);
            void copyTargetOrientation(float dt);

            float squaredDistanceToTarget() const;
            void doFire();
            void aimAtTarget();
            bool isLookingAtTarget(float angle) const;
            bool isLooking( ControllableEntity* entityThatLooks, ControllableEntity* entityBeingLookedAt, float angle )const;

            //checks if spaceship points at enemy and if there are allies inbetween
            bool canFire();
            std::map<std::string, int> weaponModes_; //<! Links each "weapon" to it's weaponmode - managed by setupWeapons()
            //std::vector<int> projectiles_; //<! Displays amount of projectiles of each weapon. - managed by setupWeapons()
            float timeout_; //<! Timeout for rocket usage. (If a rocket misses, a bot should stop using it.)
            void setupWeapons(); //<! Defines which weapons are available for a bot. Is recalled whenever a bot was killed.
            bool bSetupWorked; //<! If false, setupWeapons() is called.
            int getFiremode(std::string name);

            float randomInRange(float a, float b);
            bool bHasTargetPosition_;
            Vector3 targetPosition_;
            bool bHasTargetOrientation_;
            Quaternion targetOrientation_;

            void stopMoving();
            void setPositionOfTarget(const Vector3& target);
            void setOrientationOfTarget(const Quaternion& orient);
            bool bHasPositionOfTarget_;
            Vector3 positionOfTarget_;
            bool bHasOrientationOfTarget_;
            Quaternion orientationOfTarget_;


            WeakPtr<ControllableEntity> target_;
            //WeakPtr<ControllableEntity> thisEntity_;

            bool bEngaging_;
            bool bShooting_;
            WeakPtr<ControllableEntity> objectiveTarget_;

            void lookAtTarget(float dt);
            void stopLookingAtTarget();
            void startLookingAtTarget();
            bool bLookAtTarget_;
            void maneuver();
            void chooseManeuverType();
            void gunsD();
            void attack();
            void scissors();
            FormationMode::Value formationMode_;
            Rank::Value rank_;
            ManeuverType::Value maneuverType_;
            Maneuver::Value maneuver_;

            bool executingManeuver_;
            bool executingMoveToPoint_;
         
        private:
            
               
    };
}

#endif /* _CommonController_H__ */
