/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverWall.cc
    @brief All platforms in this minigame inherit from this class. The basic functions of a platform (interact with figure) is implemented here. Special functions are implemented in the specialized classes.
*/

#include "HoverWall.h"

#include "core/CoreIncludes.h"
#include "core/GameMode.h"
#include "graphics/Model.h"
#include "gametypes/Gametype.h"



#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(HoverWall);

    HoverWall::HoverWall(Context* context) : StaticEntity(context)
    {
        RegisterObject(HoverWall);
        model_ = NULL;
        cs_ = NULL;
    }

    HoverWall::HoverWall(Context* context, int x, int y, int orientation) : StaticEntity(context)
    {
        RegisterObject(HoverWall);

        int xSize_, zSize_, xPos_, zPos_;

        if(orientation == 1){
            xSize_ = 50;
            zSize_ = 2;
            zPos_ = x*100;
            xPos_ = y*100 -50;
        }
        else{
            xSize_ = 2;
            zSize_ = 50;
            zPos_ = x*100-50;
            xPos_ = y*100;
        }


        model_ = new Model(context);
        model_->setMeshSource("cube.mesh");
        model_->setScale3D(Vector3(xSize_, 30, zSize_));
        model_->setPosition(Vector3(xPos_,0,zPos_));

        this->attach(model_);

        this->enableCollisionCallback();
        this->setCollisionResponse(true);
        this->setCollisionType(Static);

        cs_ = new BoxCollisionShape(context);
        cs_->setHalfExtents(Vector3(xSize_, 30, zSize_));
        cs_->setPosition(Vector3(xPos_,0,zPos_));

        this->attachCollisionShape(cs_);
    }

    /**
    @brief
        Destructor.
    */
    HoverWall::~HoverWall()
    {

    }

    //xml port for loading height and width of the platform
    void HoverWall::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HoverWall, XMLPort, xmlelement, mode);

       // XMLPortParam(HoverWall, "height", setHeight, getHeight, xmlelement, mode);
        //XMLPortParam(HoverWall, "width", setWidth, getWidth, xmlelement, mode);
    }

    /**
    @brief
        Is called every tick.
        Handles the movement of the ball and its interaction with the boundaries and bats.
    @param dt
        The time since the last tick.
    */
    void HoverWall::tick(float dt)
    {
        SUPER(HoverWall, tick, dt);
        
    }

    
}
