/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverShip.cc
    @brief Implementation of the HoverShip class.
*/

#include "HoverShip.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(HoverShip);

    HoverShip::HoverShip(Context* context) : SpaceShip(context)
    {
        RegisterObject(HoverShip);
        enableCollisionCallback();
        isFloor_ = false;
    }

    void HoverShip::tick(float dt)
    {
        SUPER(HoverShip, tick, dt);
    }

    void HoverShip::moveFrontBack(const Vector2& value)
        { this->steering_.z -= value.x; }

    void HoverShip::moveRightLeft(const Vector2& value)
        { this->steering_.x += value.x; }

    void HoverShip::moveUpDown(const Vector2& value)
        { this->steering_.y += value.x; }

    void HoverShip::rotateYaw(const Vector2& value)
    {
        this->localAngularAcceleration_.setY(this->localAngularAcceleration_.y() + value.x);

        Pawn::rotateYaw(value);
    }

    void HoverShip::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HoverShip, XMLPort, xmlelement, mode);

        XMLPortParam(HoverShip, "jumpBoost", setJumpBoost, getJumpBoost, xmlelement, mode);
    }


    void HoverShip::setJumpBoost(float jumpBoost)
    {
        this->jumpBoost_ = jumpBoost;
    }


    float HoverShip::getJumpBoost()
    {
        return jumpBoost_;
    }

    /**
    @brief
        Rotate in pitch direction.
        Due to added left, can also lead to an additional up-down motion.
    @param value
        A vector whose first component specifies the magnitude of the rotation. Positive means pitch up, negative means pitch down.
    */
    void HoverShip::rotatePitch(const Vector2& value) { }

    /**
    @brief
        Rotate in roll direction.
    @param value
        A vector whose first component specifies the magnitude of the rotation. Positive means roll left, negative means roll right.
    */
    void HoverShip::rotateRoll(const Vector2& value) { }

    bool HoverShip::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* cs, btManifoldPoint& contactPoint)
    {
        SpaceShip::collidesAgainst(otherObject, cs, contactPoint);
        //SUPER(HoverShip, collidesAgainst, otherObject, cs, contactPoint);

        if (contactPoint.m_normalWorldOnB.y() > 0.6
            && this->getVelocity().y < 1) {
            this->isFloor_ = true;
        } else {
            this->isFloor_ = false;
        }

        return false;
    }

    void HoverShip::boost(bool bBoost) {
        if (bBoost && this->isFloor_)
        {
            this->setVelocity(
                this->getVelocity().x,
                jumpBoost_,
                this->getVelocity().z
                );
            this->isFloor_ = false;
        }
    }

    /*Hover* HoverShip::getGame()
    {
        if (game == NULL)
        {
            for (ObjectList<Hover>::iterator it = ObjectList<Hover>::begin(); it != ObjectList<Hover>::end(); ++it)
            {
                game = *it;
            }
        }
        return game;
    }*/
}
