/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer:  Nicolas Schlumberger
   co-programmer:

*/

#include "rf_cannon.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

#include "elements/glgui_energywidgetvertical.h"


ObjectListDefinition(RFCannon);
CREATE_FACTORY(RFCannon);

/**
 * Standard constructor
 */
RFCannon::RFCannon ()
 : Weapon()
{
    this->init();
}

RFCannon::RFCannon (const TiXmlElement* root = NULL)
 : Weapon()
{
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
RFCannon::~RFCannon()
{
}

void RFCannon::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void RFCannon::init()
{
  this->setScaling(.2);

  this->loadModel("models/guns/rf_cannon.obj", this->getScaling());


  this->setStateDuration(WS_SHOOTING, 0.1);  // 10 Schuss pro Sekunde
  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);

  this->setActionSound(WA_SHOOT, "sounds/guns/laser.wav");
  this->setActionSound(WA_RELOAD, "sounds/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("PlasmaPulse");
  this->prepareProjectiles(25);

  this->setBarrels(4);
//   this->setSegs(1);
  this->setActiveBarrel(rand() % 4);


  this->setEmissionPoint(Vector(4.1, 0.0, 0.75) * this->getScaling(), 0);
  this->setEmissionPoint(Vector(4.1, 0.45, 0.0) * this->getScaling(), 1);
  this->setEmissionPoint(Vector(4.1, 0.0, -0.75) * this->getScaling(), 2);
  this->setEmissionPoint(Vector(4.1, -0.45, 0.0) * this->getScaling(), 3);

  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}

void RFCannon::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());

  pj->setParent(PNode::getNullParent());

//   pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*190);
  Vector tmp = this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor();

  pj->setVelocity(this->getParent()->getVelocity() + (tmp.getNormalized())*190);

  pj->setAbsCoor(this->getEmissionPoint());
  //FIXME pj needs a absDir
//   pj->setAbsDir(this->getAbsDir());
//   pj->setAbsDir(Quaternion(tmp.getNormalized(), this->getParent()->getAbsDir().apply(Vector(0,1,0))));

  pj->activate();

  this->cycleBarrel();
}

/**
 *  this activates the weapon
*/
void RFCannon::activate()
{
}

/**
 *  this deactivates the weapon
*/
void RFCannon::deactivate()
{
}

void RFCannon::draw() const
{
  glPushMatrix();
    glMatrixMode(GL_MODELVIEW);
    glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    static_cast<StaticModel*>(this->getModel())->draw();
  glPopMatrix();

}

void RFCannon::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  if (this->energyWidget != NULL && !this->isEnergyWidgetInitialized)
  {
    this->energyWidget->setDisplayedImage("textures/gui/gui_light_bolt.png");
    this->setEnergyWidgetInitialized(true);
  }
}
